/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering;

public class DescribeReservedCacheNodesOfferingsIterable
implements SdkIterable<DescribeReservedCacheNodesOfferingsResponse> {
    private final ElastiCacheClient client;
    private final DescribeReservedCacheNodesOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedCacheNodesOfferingsIterable(ElastiCacheClient client, DescribeReservedCacheNodesOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedCacheNodesOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedCacheNodesOfferingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ReservedCacheNodesOffering> reservedCacheNodesOfferings() {
        Function<DescribeReservedCacheNodesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedCacheNodesOfferings() != null) {
                return response.reservedCacheNodesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeReservedCacheNodesOfferingsIterable resume(DescribeReservedCacheNodesOfferingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedCacheNodesOfferingsIterable(this.client, (DescribeReservedCacheNodesOfferingsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedCacheNodesOfferingsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReservedCacheNodesOfferingsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReservedCacheNodesOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeReservedCacheNodesOfferingsResponse> {
        private DescribeReservedCacheNodesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedCacheNodesOfferingsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedCacheNodesOfferingsResponse nextPage(DescribeReservedCacheNodesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedCacheNodesOfferingsIterable.this.client.describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsIterable.this.firstRequest);
            }
            return DescribeReservedCacheNodesOfferingsIterable.this.client.describeReservedCacheNodesOfferings((DescribeReservedCacheNodesOfferingsRequest)((Object)DescribeReservedCacheNodesOfferingsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

