/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;

public class DescribeCacheClustersIterable
implements SdkIterable<DescribeCacheClustersResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCacheClustersIterable(ElastiCacheClient client, DescribeCacheClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheClustersResponseFetcher();
    }

    public Iterator<DescribeCacheClustersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<CacheCluster> cacheClusters() {
        Function<DescribeCacheClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheClusters() != null) {
                return response.cacheClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeCacheClustersIterable resume(DescribeCacheClustersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheClustersIterable(this.client, (DescribeCacheClustersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheClustersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeCacheClustersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeCacheClustersResponseFetcher
    implements SyncPageFetcher<DescribeCacheClustersResponse> {
        private DescribeCacheClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheClustersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheClustersResponse nextPage(DescribeCacheClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheClustersIterable.this.client.describeCacheClusters(DescribeCacheClustersIterable.this.firstRequest);
            }
            return DescribeCacheClustersIterable.this.client.describeCacheClusters((DescribeCacheClustersRequest)((Object)DescribeCacheClustersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

