/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus;
import software.amazon.awssdk.services.elasticache.model.NodeSnapshot;
import software.amazon.awssdk.services.elasticache.model.NodeSnapshotListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Snapshot
implements ToCopyableBuilder<Builder, Snapshot> {
    private final String snapshotName;
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String cacheClusterId;
    private final String snapshotStatus;
    private final String snapshotSource;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final Integer numCacheNodes;
    private final String preferredAvailabilityZone;
    private final Instant cacheClusterCreateTime;
    private final String preferredMaintenanceWindow;
    private final String topicArn;
    private final Integer port;
    private final String cacheParameterGroupName;
    private final String cacheSubnetGroupName;
    private final String vpcId;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final Integer numNodeGroups;
    private final String automaticFailover;
    private final List<NodeSnapshot> nodeSnapshots;

    private Snapshot(BuilderImpl builder) {
        this.snapshotName = builder.snapshotName;
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.cacheClusterId = builder.cacheClusterId;
        this.snapshotStatus = builder.snapshotStatus;
        this.snapshotSource = builder.snapshotSource;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.numCacheNodes = builder.numCacheNodes;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.cacheClusterCreateTime = builder.cacheClusterCreateTime;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.topicArn = builder.topicArn;
        this.port = builder.port;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.vpcId = builder.vpcId;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.numNodeGroups = builder.numNodeGroups;
        this.automaticFailover = builder.automaticFailover;
        this.nodeSnapshots = builder.nodeSnapshots;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String snapshotStatus() {
        return this.snapshotStatus;
    }

    public String snapshotSource() {
        return this.snapshotSource;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public String preferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public Instant cacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public Integer port() {
        return this.port;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public Integer numNodeGroups() {
        return this.numNodeGroups;
    }

    public AutomaticFailoverStatus automaticFailover() {
        return AutomaticFailoverStatus.fromValue(this.automaticFailover);
    }

    public String automaticFailoverString() {
        return this.automaticFailover;
    }

    public List<NodeSnapshot> nodeSnapshots() {
        return this.nodeSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeSnapshots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.replicationGroupDescription(), other.replicationGroupDescription()) && Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.snapshotStatus(), other.snapshotStatus()) && Objects.equals(this.snapshotSource(), other.snapshotSource()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.numCacheNodes(), other.numCacheNodes()) && Objects.equals(this.preferredAvailabilityZone(), other.preferredAvailabilityZone()) && Objects.equals(this.cacheClusterCreateTime(), other.cacheClusterCreateTime()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.numNodeGroups(), other.numNodeGroups()) && Objects.equals(this.automaticFailoverString(), other.automaticFailoverString()) && Objects.equals(this.nodeSnapshots(), other.nodeSnapshots());
    }

    public String toString() {
        return ToString.builder((String)"Snapshot").add("SnapshotName", (Object)this.snapshotName()).add("ReplicationGroupId", (Object)this.replicationGroupId()).add("ReplicationGroupDescription", (Object)this.replicationGroupDescription()).add("CacheClusterId", (Object)this.cacheClusterId()).add("SnapshotStatus", (Object)this.snapshotStatus()).add("SnapshotSource", (Object)this.snapshotSource()).add("CacheNodeType", (Object)this.cacheNodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("NumCacheNodes", (Object)this.numCacheNodes()).add("PreferredAvailabilityZone", (Object)this.preferredAvailabilityZone()).add("CacheClusterCreateTime", (Object)this.cacheClusterCreateTime()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("TopicArn", (Object)this.topicArn()).add("Port", (Object)this.port()).add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("VpcId", (Object)this.vpcId()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("NumNodeGroups", (Object)this.numNodeGroups()).add("AutomaticFailover", (Object)this.automaticFailoverString()).add("NodeSnapshots", this.nodeSnapshots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotName": {
                return Optional.of(clazz.cast(this.snapshotName()));
            }
            case "ReplicationGroupId": {
                return Optional.of(clazz.cast(this.replicationGroupId()));
            }
            case "ReplicationGroupDescription": {
                return Optional.of(clazz.cast(this.replicationGroupDescription()));
            }
            case "CacheClusterId": {
                return Optional.of(clazz.cast(this.cacheClusterId()));
            }
            case "SnapshotStatus": {
                return Optional.of(clazz.cast(this.snapshotStatus()));
            }
            case "SnapshotSource": {
                return Optional.of(clazz.cast(this.snapshotSource()));
            }
            case "CacheNodeType": {
                return Optional.of(clazz.cast(this.cacheNodeType()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "NumCacheNodes": {
                return Optional.of(clazz.cast(this.numCacheNodes()));
            }
            case "PreferredAvailabilityZone": {
                return Optional.of(clazz.cast(this.preferredAvailabilityZone()));
            }
            case "CacheClusterCreateTime": {
                return Optional.of(clazz.cast(this.cacheClusterCreateTime()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "CacheParameterGroupName": {
                return Optional.of(clazz.cast(this.cacheParameterGroupName()));
            }
            case "CacheSubnetGroupName": {
                return Optional.of(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.of(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.of(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.of(clazz.cast(this.snapshotWindow()));
            }
            case "NumNodeGroups": {
                return Optional.of(clazz.cast(this.numNodeGroups()));
            }
            case "AutomaticFailover": {
                return Optional.of(clazz.cast(this.automaticFailoverString()));
            }
            case "NodeSnapshots": {
                return Optional.of(clazz.cast(this.nodeSnapshots()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotName;
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String cacheClusterId;
        private String snapshotStatus;
        private String snapshotSource;
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private Integer numCacheNodes;
        private String preferredAvailabilityZone;
        private Instant cacheClusterCreateTime;
        private String preferredMaintenanceWindow;
        private String topicArn;
        private Integer port;
        private String cacheParameterGroupName;
        private String cacheSubnetGroupName;
        private String vpcId;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private Integer numNodeGroups;
        private String automaticFailover;
        private List<NodeSnapshot> nodeSnapshots;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.snapshotName(model.snapshotName);
            this.replicationGroupId(model.replicationGroupId);
            this.replicationGroupDescription(model.replicationGroupDescription);
            this.cacheClusterId(model.cacheClusterId);
            this.snapshotStatus(model.snapshotStatus);
            this.snapshotSource(model.snapshotSource);
            this.cacheNodeType(model.cacheNodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.numCacheNodes(model.numCacheNodes);
            this.preferredAvailabilityZone(model.preferredAvailabilityZone);
            this.cacheClusterCreateTime(model.cacheClusterCreateTime);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.topicArn(model.topicArn);
            this.port(model.port);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.vpcId(model.vpcId);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.numNodeGroups(model.numNodeGroups);
            this.automaticFailover(model.automaticFailover);
            this.nodeSnapshots(model.nodeSnapshots);
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getSnapshotStatus() {
            return this.snapshotStatus;
        }

        @Override
        public final Builder snapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
            return this;
        }

        public final void setSnapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
        }

        public final String getSnapshotSource() {
            return this.snapshotSource;
        }

        @Override
        public final Builder snapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
            return this;
        }

        public final void setSnapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        public final Instant getCacheClusterCreateTime() {
            return this.cacheClusterCreateTime;
        }

        @Override
        public final Builder cacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
            return this;
        }

        public final void setCacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final Integer getNumNodeGroups() {
            return this.numNodeGroups;
        }

        @Override
        public final Builder numNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        public final void setNumNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
        }

        public final String getAutomaticFailover() {
            return this.automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover.toString());
            return this;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        public final Collection<NodeSnapshot.Builder> getNodeSnapshots() {
            return this.nodeSnapshots != null ? (Collection)this.nodeSnapshots.stream().map(NodeSnapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeSnapshots(Collection<NodeSnapshot> nodeSnapshots) {
            this.nodeSnapshots = NodeSnapshotListCopier.copy(nodeSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSnapshots(NodeSnapshot ... nodeSnapshots) {
            this.nodeSnapshots(Arrays.asList(nodeSnapshots));
            return this;
        }

        public final void setNodeSnapshots(Collection<NodeSnapshot.BuilderImpl> nodeSnapshots) {
            this.nodeSnapshots = NodeSnapshotListCopier.copyFromBuilder(nodeSnapshots);
        }

        public Snapshot build() {
            return new Snapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Snapshot> {
        public Builder snapshotName(String var1);

        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder cacheClusterId(String var1);

        public Builder snapshotStatus(String var1);

        public Builder snapshotSource(String var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder numCacheNodes(Integer var1);

        public Builder preferredAvailabilityZone(String var1);

        public Builder cacheClusterCreateTime(Instant var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder topicArn(String var1);

        public Builder port(Integer var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder cacheSubnetGroupName(String var1);

        public Builder vpcId(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder numNodeGroups(Integer var1);

        public Builder automaticFailover(String var1);

        public Builder automaticFailover(AutomaticFailoverStatus var1);

        public Builder nodeSnapshots(Collection<NodeSnapshot> var1);

        public Builder nodeSnapshots(NodeSnapshot ... var1);
    }
}

