/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NodeGroupConfiguration
implements ToCopyableBuilder<Builder, NodeGroupConfiguration> {
    private final String slots;
    private final Integer replicaCount;
    private final String primaryAvailabilityZone;
    private final List<String> replicaAvailabilityZones;

    private NodeGroupConfiguration(BuilderImpl builder) {
        this.slots = builder.slots;
        this.replicaCount = builder.replicaCount;
        this.primaryAvailabilityZone = builder.primaryAvailabilityZone;
        this.replicaAvailabilityZones = builder.replicaAvailabilityZones;
    }

    public String slots() {
        return this.slots;
    }

    public Integer replicaCount() {
        return this.replicaCount;
    }

    public String primaryAvailabilityZone() {
        return this.primaryAvailabilityZone;
    }

    public List<String> replicaAvailabilityZones() {
        return this.replicaAvailabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaAvailabilityZones());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupConfiguration)) {
            return false;
        }
        NodeGroupConfiguration other = (NodeGroupConfiguration)obj;
        return Objects.equals(this.slots(), other.slots()) && Objects.equals(this.replicaCount(), other.replicaCount()) && Objects.equals(this.primaryAvailabilityZone(), other.primaryAvailabilityZone()) && Objects.equals(this.replicaAvailabilityZones(), other.replicaAvailabilityZones());
    }

    public String toString() {
        return ToString.builder((String)"NodeGroupConfiguration").add("Slots", (Object)this.slots()).add("ReplicaCount", (Object)this.replicaCount()).add("PrimaryAvailabilityZone", (Object)this.primaryAvailabilityZone()).add("ReplicaAvailabilityZones", this.replicaAvailabilityZones()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Slots": {
                return Optional.of(clazz.cast(this.slots()));
            }
            case "ReplicaCount": {
                return Optional.of(clazz.cast(this.replicaCount()));
            }
            case "PrimaryAvailabilityZone": {
                return Optional.of(clazz.cast(this.primaryAvailabilityZone()));
            }
            case "ReplicaAvailabilityZones": {
                return Optional.of(clazz.cast(this.replicaAvailabilityZones()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String slots;
        private Integer replicaCount;
        private String primaryAvailabilityZone;
        private List<String> replicaAvailabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupConfiguration model) {
            this.slots(model.slots);
            this.replicaCount(model.replicaCount);
            this.primaryAvailabilityZone(model.primaryAvailabilityZone);
            this.replicaAvailabilityZones(model.replicaAvailabilityZones);
        }

        public final String getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        public final Integer getReplicaCount() {
            return this.replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        public final String getPrimaryAvailabilityZone() {
            return this.primaryAvailabilityZone;
        }

        @Override
        public final Builder primaryAvailabilityZone(String primaryAvailabilityZone) {
            this.primaryAvailabilityZone = primaryAvailabilityZone;
            return this;
        }

        public final void setPrimaryAvailabilityZone(String primaryAvailabilityZone) {
            this.primaryAvailabilityZone = primaryAvailabilityZone;
        }

        public final Collection<String> getReplicaAvailabilityZones() {
            return this.replicaAvailabilityZones;
        }

        @Override
        public final Builder replicaAvailabilityZones(Collection<String> replicaAvailabilityZones) {
            this.replicaAvailabilityZones = AvailabilityZonesListCopier.copy(replicaAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaAvailabilityZones(String ... replicaAvailabilityZones) {
            this.replicaAvailabilityZones(Arrays.asList(replicaAvailabilityZones));
            return this;
        }

        public final void setReplicaAvailabilityZones(Collection<String> replicaAvailabilityZones) {
            this.replicaAvailabilityZones = AvailabilityZonesListCopier.copy(replicaAvailabilityZones);
        }

        public NodeGroupConfiguration build() {
            return new NodeGroupConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NodeGroupConfiguration> {
        public Builder slots(String var1);

        public Builder replicaCount(Integer var1);

        public Builder primaryAvailabilityZone(String var1);

        public Builder replicaAvailabilityZones(Collection<String> var1);

        public Builder replicaAvailabilityZones(String ... var1);
    }
}

