/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfigurationListCopier;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.SnapshotArnsListCopier;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateReplicationGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CreateReplicationGroupRequest> {
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String primaryClusterId;
    private final Boolean automaticFailoverEnabled;
    private final Integer numCacheClusters;
    private final List<String> preferredCacheClusterAZs;
    private final Integer numNodeGroups;
    private final Integer replicasPerNodeGroup;
    private final List<NodeGroupConfiguration> nodeGroupConfiguration;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final String cacheParameterGroupName;
    private final String cacheSubnetGroupName;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final List<Tag> tags;
    private final List<String> snapshotArns;
    private final String snapshotName;
    private final String preferredMaintenanceWindow;
    private final Integer port;
    private final String notificationTopicArn;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String authToken;
    private final Boolean transitEncryptionEnabled;
    private final Boolean atRestEncryptionEnabled;

    private CreateReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.numCacheClusters = builder.numCacheClusters;
        this.preferredCacheClusterAZs = builder.preferredCacheClusterAZs;
        this.numNodeGroups = builder.numNodeGroups;
        this.replicasPerNodeGroup = builder.replicasPerNodeGroup;
        this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.port = builder.port;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authToken = builder.authToken;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public String primaryClusterId() {
        return this.primaryClusterId;
    }

    public Boolean automaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }

    public Integer numCacheClusters() {
        return this.numCacheClusters;
    }

    public List<String> preferredCacheClusterAZs() {
        return this.preferredCacheClusterAZs;
    }

    public Integer numNodeGroups() {
        return this.numNodeGroups;
    }

    public Integer replicasPerNodeGroup() {
        return this.replicasPerNodeGroup;
    }

    public List<NodeGroupConfiguration> nodeGroupConfiguration() {
        return this.nodeGroupConfiguration;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<String> snapshotArns() {
        return this.snapshotArns;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Integer port() {
        return this.port;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public String authToken() {
        return this.authToken;
    }

    public Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public Boolean atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheClusters());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredCacheClusterAZs());
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicasPerNodeGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.atRestEncryptionEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationGroupRequest)) {
            return false;
        }
        CreateReplicationGroupRequest other = (CreateReplicationGroupRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.replicationGroupDescription(), other.replicationGroupDescription()) && Objects.equals(this.primaryClusterId(), other.primaryClusterId()) && Objects.equals(this.automaticFailoverEnabled(), other.automaticFailoverEnabled()) && Objects.equals(this.numCacheClusters(), other.numCacheClusters()) && Objects.equals(this.preferredCacheClusterAZs(), other.preferredCacheClusterAZs()) && Objects.equals(this.numNodeGroups(), other.numNodeGroups()) && Objects.equals(this.replicasPerNodeGroup(), other.replicasPerNodeGroup()) && Objects.equals(this.nodeGroupConfiguration(), other.nodeGroupConfiguration()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && Objects.equals(this.cacheSecurityGroupNames(), other.cacheSecurityGroupNames()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.snapshotArns(), other.snapshotArns()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.notificationTopicArn(), other.notificationTopicArn()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.authToken(), other.authToken()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.atRestEncryptionEnabled(), other.atRestEncryptionEnabled());
    }

    public String toString() {
        return ToString.builder((String)"CreateReplicationGroupRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("ReplicationGroupDescription", (Object)this.replicationGroupDescription()).add("PrimaryClusterId", (Object)this.primaryClusterId()).add("AutomaticFailoverEnabled", (Object)this.automaticFailoverEnabled()).add("NumCacheClusters", (Object)this.numCacheClusters()).add("PreferredCacheClusterAZs", this.preferredCacheClusterAZs()).add("NumNodeGroups", (Object)this.numNodeGroups()).add("ReplicasPerNodeGroup", (Object)this.replicasPerNodeGroup()).add("NodeGroupConfiguration", this.nodeGroupConfiguration()).add("CacheNodeType", (Object)this.cacheNodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("CacheSecurityGroupNames", this.cacheSecurityGroupNames()).add("SecurityGroupIds", this.securityGroupIds()).add("Tags", this.tags()).add("SnapshotArns", this.snapshotArns()).add("SnapshotName", (Object)this.snapshotName()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("Port", (Object)this.port()).add("NotificationTopicArn", (Object)this.notificationTopicArn()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("AuthToken", (Object)this.authToken()).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("AtRestEncryptionEnabled", (Object)this.atRestEncryptionEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.of(clazz.cast(this.replicationGroupId()));
            }
            case "ReplicationGroupDescription": {
                return Optional.of(clazz.cast(this.replicationGroupDescription()));
            }
            case "PrimaryClusterId": {
                return Optional.of(clazz.cast(this.primaryClusterId()));
            }
            case "AutomaticFailoverEnabled": {
                return Optional.of(clazz.cast(this.automaticFailoverEnabled()));
            }
            case "NumCacheClusters": {
                return Optional.of(clazz.cast(this.numCacheClusters()));
            }
            case "PreferredCacheClusterAZs": {
                return Optional.of(clazz.cast(this.preferredCacheClusterAZs()));
            }
            case "NumNodeGroups": {
                return Optional.of(clazz.cast(this.numNodeGroups()));
            }
            case "ReplicasPerNodeGroup": {
                return Optional.of(clazz.cast(this.replicasPerNodeGroup()));
            }
            case "NodeGroupConfiguration": {
                return Optional.of(clazz.cast(this.nodeGroupConfiguration()));
            }
            case "CacheNodeType": {
                return Optional.of(clazz.cast(this.cacheNodeType()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "CacheParameterGroupName": {
                return Optional.of(clazz.cast(this.cacheParameterGroupName()));
            }
            case "CacheSubnetGroupName": {
                return Optional.of(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "CacheSecurityGroupNames": {
                return Optional.of(clazz.cast(this.cacheSecurityGroupNames()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "SnapshotArns": {
                return Optional.of(clazz.cast(this.snapshotArns()));
            }
            case "SnapshotName": {
                return Optional.of(clazz.cast(this.snapshotName()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "NotificationTopicArn": {
                return Optional.of(clazz.cast(this.notificationTopicArn()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.of(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.of(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.of(clazz.cast(this.snapshotWindow()));
            }
            case "AuthToken": {
                return Optional.of(clazz.cast(this.authToken()));
            }
            case "TransitEncryptionEnabled": {
                return Optional.of(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "AtRestEncryptionEnabled": {
                return Optional.of(clazz.cast(this.atRestEncryptionEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String primaryClusterId;
        private Boolean automaticFailoverEnabled;
        private Integer numCacheClusters;
        private List<String> preferredCacheClusterAZs;
        private Integer numNodeGroups;
        private Integer replicasPerNodeGroup;
        private List<NodeGroupConfiguration> nodeGroupConfiguration;
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private String cacheParameterGroupName;
        private String cacheSubnetGroupName;
        private List<String> cacheSecurityGroupNames;
        private List<String> securityGroupIds;
        private List<Tag> tags;
        private List<String> snapshotArns;
        private String snapshotName;
        private String preferredMaintenanceWindow;
        private Integer port;
        private String notificationTopicArn;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String authToken;
        private Boolean transitEncryptionEnabled;
        private Boolean atRestEncryptionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationGroupRequest model) {
            this.replicationGroupId(model.replicationGroupId);
            this.replicationGroupDescription(model.replicationGroupDescription);
            this.primaryClusterId(model.primaryClusterId);
            this.automaticFailoverEnabled(model.automaticFailoverEnabled);
            this.numCacheClusters(model.numCacheClusters);
            this.preferredCacheClusterAZs(model.preferredCacheClusterAZs);
            this.numNodeGroups(model.numNodeGroups);
            this.replicasPerNodeGroup(model.replicasPerNodeGroup);
            this.nodeGroupConfiguration(model.nodeGroupConfiguration);
            this.cacheNodeType(model.cacheNodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.securityGroupIds(model.securityGroupIds);
            this.tags(model.tags);
            this.snapshotArns(model.snapshotArns);
            this.snapshotName(model.snapshotName);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.port(model.port);
            this.notificationTopicArn(model.notificationTopicArn);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.authToken(model.authToken);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.atRestEncryptionEnabled(model.atRestEncryptionEnabled);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return this.automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        public final Integer getNumCacheClusters() {
            return this.numCacheClusters;
        }

        @Override
        public final Builder numCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
            return this;
        }

        public final void setNumCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
        }

        public final Collection<String> getPreferredCacheClusterAZs() {
            return this.preferredCacheClusterAZs;
        }

        @Override
        public final Builder preferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredCacheClusterAZs(String ... preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs(Arrays.asList(preferredCacheClusterAZs));
            return this;
        }

        public final void setPreferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
        }

        public final Integer getNumNodeGroups() {
            return this.numNodeGroups;
        }

        @Override
        public final Builder numNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        public final void setNumNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
        }

        public final Integer getReplicasPerNodeGroup() {
            return this.replicasPerNodeGroup;
        }

        @Override
        public final Builder replicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
            return this;
        }

        public final void setReplicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
        }

        public final Collection<NodeGroupConfiguration.Builder> getNodeGroupConfiguration() {
            return this.nodeGroupConfiguration != null ? (Collection)this.nodeGroupConfiguration.stream().map(NodeGroupConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copy(nodeGroupConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(NodeGroupConfiguration ... nodeGroupConfiguration) {
            this.nodeGroupConfiguration(Arrays.asList(nodeGroupConfiguration));
            return this;
        }

        public final void setNodeGroupConfiguration(Collection<NodeGroupConfiguration.BuilderImpl> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copyFromBuilder(nodeGroupConfiguration);
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getSnapshotArns() {
            return this.snapshotArns;
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String ... snapshotArns) {
            this.snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationGroupRequest build() {
            return new CreateReplicationGroupRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, CreateReplicationGroupRequest> {
        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder primaryClusterId(String var1);

        public Builder automaticFailoverEnabled(Boolean var1);

        public Builder numCacheClusters(Integer var1);

        public Builder preferredCacheClusterAZs(Collection<String> var1);

        public Builder preferredCacheClusterAZs(String ... var1);

        public Builder numNodeGroups(Integer var1);

        public Builder replicasPerNodeGroup(Integer var1);

        public Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> var1);

        public Builder nodeGroupConfiguration(NodeGroupConfiguration ... var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder snapshotArns(Collection<String> var1);

        public Builder snapshotArns(String ... var1);

        public Builder snapshotName(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder port(Integer var1);

        public Builder notificationTopicArn(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder authToken(String var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder atRestEncryptionEnabled(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

