/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.Subnet;
import software.amazon.awssdk.services.elasticache.model.SubnetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CacheSubnetGroup
implements ToCopyableBuilder<Builder, CacheSubnetGroup> {
    private final String cacheSubnetGroupName;
    private final String cacheSubnetGroupDescription;
    private final String vpcId;
    private final List<Subnet> subnets;

    private CacheSubnetGroup(BuilderImpl builder) {
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSubnetGroupDescription = builder.cacheSubnetGroupDescription;
        this.vpcId = builder.vpcId;
        this.subnets = builder.subnets;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public String cacheSubnetGroupDescription() {
        return this.cacheSubnetGroupDescription;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSubnetGroup)) {
            return false;
        }
        CacheSubnetGroup other = (CacheSubnetGroup)obj;
        return Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && Objects.equals(this.cacheSubnetGroupDescription(), other.cacheSubnetGroupDescription()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnets(), other.subnets());
    }

    public String toString() {
        return ToString.builder((String)"CacheSubnetGroup").add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("CacheSubnetGroupDescription", (Object)this.cacheSubnetGroupDescription()).add("VpcId", (Object)this.vpcId()).add("Subnets", this.subnets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheSubnetGroupName": {
                return Optional.of(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "CacheSubnetGroupDescription": {
                return Optional.of(clazz.cast(this.cacheSubnetGroupDescription()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "Subnets": {
                return Optional.of(clazz.cast(this.subnets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheSubnetGroupName;
        private String cacheSubnetGroupDescription;
        private String vpcId;
        private List<Subnet> subnets;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheSubnetGroup model) {
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.cacheSubnetGroupDescription(model.cacheSubnetGroupDescription);
            this.vpcId(model.vpcId);
            this.subnets(model.subnets);
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final String getCacheSubnetGroupDescription() {
            return this.cacheSubnetGroupDescription;
        }

        @Override
        public final Builder cacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
            return this;
        }

        public final void setCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<Subnet.Builder> getSubnets() {
            return this.subnets != null ? (Collection)this.subnets.stream().map(Subnet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        public CacheSubnetGroup build() {
            return new CacheSubnetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheSubnetGroup> {
        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSubnetGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);
    }
}

