/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest;

public class ModifyCacheClusterRequestMarshaller
implements Marshaller<Request<ModifyCacheClusterRequest>, ModifyCacheClusterRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<ModifyCacheClusterRequest> marshall(ModifyCacheClusterRequest modifyCacheClusterRequest) {
        List<String> list;
        List<String> cacheSecurityGroupNamesList;
        List<String> newAvailabilityZonesList;
        List<String> cacheNodeIdsToRemoveList;
        if (modifyCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)modifyCacheClusterRequest.cacheClusterId()));
        }
        if (modifyCacheClusterRequest.numCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringUtils.fromInteger((Integer)modifyCacheClusterRequest.numCacheNodes()));
        }
        if ((cacheNodeIdsToRemoveList = modifyCacheClusterRequest.cacheNodeIdsToRemove()) != null) {
            if (!cacheNodeIdsToRemoveList.isEmpty()) {
                int cacheNodeIdsToRemoveListIndex = 1;
                for (String string : cacheNodeIdsToRemoveList) {
                    if (string != null) {
                        request.addParameter("CacheNodeIdsToRemove.CacheNodeId." + cacheNodeIdsToRemoveListIndex, StringUtils.fromString((String)string));
                    }
                    ++cacheNodeIdsToRemoveListIndex;
                }
            } else {
                request.addParameter("CacheNodeIdsToRemove", "");
            }
        }
        if (modifyCacheClusterRequest.azModeString() != null) {
            request.addParameter("AZMode", StringUtils.fromString((String)modifyCacheClusterRequest.azModeString()));
        }
        if ((newAvailabilityZonesList = modifyCacheClusterRequest.newAvailabilityZones()) != null) {
            if (!newAvailabilityZonesList.isEmpty()) {
                int newAvailabilityZonesListIndex = 1;
                for (String string : newAvailabilityZonesList) {
                    if (string != null) {
                        request.addParameter("NewAvailabilityZones.PreferredAvailabilityZone." + newAvailabilityZonesListIndex, StringUtils.fromString((String)string));
                    }
                    ++newAvailabilityZonesListIndex;
                }
            } else {
                request.addParameter("NewAvailabilityZones", "");
            }
        }
        if ((cacheSecurityGroupNamesList = modifyCacheClusterRequest.cacheSecurityGroupNames()) != null) {
            if (!cacheSecurityGroupNamesList.isEmpty()) {
                boolean bl = true;
                for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                    void var6_12;
                    if (cacheSecurityGroupNamesListValue != null) {
                        request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + (int)var6_12, StringUtils.fromString((String)cacheSecurityGroupNamesListValue));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("CacheSecurityGroupNames", "");
            }
        }
        if ((list = modifyCacheClusterRequest.securityGroupIds()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (String securityGroupIdsListValue : list) {
                    void var7_18;
                    if (securityGroupIdsListValue != null) {
                        request.addParameter("SecurityGroupIds.SecurityGroupId." + (int)var7_18, StringUtils.fromString((String)securityGroupIdsListValue));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("SecurityGroupIds", "");
            }
        }
        if (modifyCacheClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyCacheClusterRequest.preferredMaintenanceWindow()));
        }
        if (modifyCacheClusterRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)modifyCacheClusterRequest.notificationTopicArn()));
        }
        if (modifyCacheClusterRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)modifyCacheClusterRequest.cacheParameterGroupName()));
        }
        if (modifyCacheClusterRequest.notificationTopicStatus() != null) {
            request.addParameter("NotificationTopicStatus", StringUtils.fromString((String)modifyCacheClusterRequest.notificationTopicStatus()));
        }
        if (modifyCacheClusterRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyCacheClusterRequest.applyImmediately()));
        }
        if (modifyCacheClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyCacheClusterRequest.engineVersion()));
        }
        if (modifyCacheClusterRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyCacheClusterRequest.autoMinorVersionUpgrade()));
        }
        if (modifyCacheClusterRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)modifyCacheClusterRequest.snapshotRetentionLimit()));
        }
        if (modifyCacheClusterRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)modifyCacheClusterRequest.snapshotWindow()));
        }
        if (modifyCacheClusterRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)modifyCacheClusterRequest.cacheNodeType()));
        }
        return request;
    }
}

