/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest;

public class DescribeReservedCacheNodesRequestMarshaller
implements Marshaller<Request<DescribeReservedCacheNodesRequest>, DescribeReservedCacheNodesRequest> {
    public Request<DescribeReservedCacheNodesRequest> marshall(DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) {
        if (describeReservedCacheNodesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeReservedCacheNodesRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeReservedCacheNodes");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedCacheNodesRequest.reservedCacheNodeId() != null) {
            request.addParameter("ReservedCacheNodeId", StringUtils.fromString((String)describeReservedCacheNodesRequest.reservedCacheNodeId()));
        }
        if (describeReservedCacheNodesRequest.reservedCacheNodesOfferingId() != null) {
            request.addParameter("ReservedCacheNodesOfferingId", StringUtils.fromString((String)describeReservedCacheNodesRequest.reservedCacheNodesOfferingId()));
        }
        if (describeReservedCacheNodesRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)describeReservedCacheNodesRequest.cacheNodeType()));
        }
        if (describeReservedCacheNodesRequest.duration() != null) {
            request.addParameter("Duration", StringUtils.fromString((String)describeReservedCacheNodesRequest.duration()));
        }
        if (describeReservedCacheNodesRequest.productDescription() != null) {
            request.addParameter("ProductDescription", StringUtils.fromString((String)describeReservedCacheNodesRequest.productDescription()));
        }
        if (describeReservedCacheNodesRequest.offeringType() != null) {
            request.addParameter("OfferingType", StringUtils.fromString((String)describeReservedCacheNodesRequest.offeringType()));
        }
        if (describeReservedCacheNodesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeReservedCacheNodesRequest.maxRecords()));
        }
        if (describeReservedCacheNodesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeReservedCacheNodesRequest.marker()));
        }
        return request;
    }
}

