/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest;

public class DescribeCacheParameterGroupsRequestMarshaller
implements Marshaller<Request<DescribeCacheParameterGroupsRequest>, DescribeCacheParameterGroupsRequest> {
    public Request<DescribeCacheParameterGroupsRequest> marshall(DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) {
        if (describeCacheParameterGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeCacheParameterGroupsRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeCacheParameterGroups");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheParameterGroupsRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)describeCacheParameterGroupsRequest.cacheParameterGroupName()));
        }
        if (describeCacheParameterGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeCacheParameterGroupsRequest.maxRecords()));
        }
        if (describeCacheParameterGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeCacheParameterGroupsRequest.marker()));
        }
        return request;
    }
}

