/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;

public final class DescribeCacheClustersPaginator
implements SdkIterable<DescribeCacheClustersResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheClustersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeCacheClustersPaginator(ElastiCacheClient client, DescribeCacheClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheClustersResponseFetcher();
    }

    public Iterator<DescribeCacheClustersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<CacheCluster> cacheClusters() {
        Function<DescribeCacheClustersResponse, Iterator> getIterator = response -> response != null ? response.cacheClusters().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeCacheClustersResponseFetcher
    implements NextPageFetcher<DescribeCacheClustersResponse> {
        private DescribeCacheClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheClustersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheClustersResponse nextPage(DescribeCacheClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheClustersPaginator.this.client.describeCacheClusters(DescribeCacheClustersPaginator.this.firstRequest);
            }
            return DescribeCacheClustersPaginator.this.client.describeCacheClusters((DescribeCacheClustersRequest)((Object)DescribeCacheClustersPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

