/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus;
import software.amazon.awssdk.services.elasticache.model.ReshardingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReplicationGroupPendingModifiedValues
implements ToCopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
    private final String primaryClusterId;
    private final String automaticFailoverStatus;
    private final ReshardingStatus resharding;

    private ReplicationGroupPendingModifiedValues(BuilderImpl builder) {
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverStatus = builder.automaticFailoverStatus;
        this.resharding = builder.resharding;
    }

    public String primaryClusterId() {
        return this.primaryClusterId;
    }

    public PendingAutomaticFailoverStatus automaticFailoverStatus() {
        return PendingAutomaticFailoverStatus.fromValue(this.automaticFailoverStatus);
    }

    public String automaticFailoverStatusString() {
        return this.automaticFailoverStatus;
    }

    public ReshardingStatus resharding() {
        return this.resharding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resharding());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupPendingModifiedValues)) {
            return false;
        }
        ReplicationGroupPendingModifiedValues other = (ReplicationGroupPendingModifiedValues)obj;
        return Objects.equals(this.primaryClusterId(), other.primaryClusterId()) && Objects.equals(this.automaticFailoverStatusString(), other.automaticFailoverStatusString()) && Objects.equals(this.resharding(), other.resharding());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationGroupPendingModifiedValues").add("PrimaryClusterId", (Object)this.primaryClusterId()).add("AutomaticFailoverStatus", (Object)this.automaticFailoverStatusString()).add("Resharding", (Object)this.resharding()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryClusterId": {
                return Optional.of(clazz.cast(this.primaryClusterId()));
            }
            case "AutomaticFailoverStatus": {
                return Optional.of(clazz.cast(this.automaticFailoverStatusString()));
            }
            case "Resharding": {
                return Optional.of(clazz.cast(this.resharding()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryClusterId;
        private String automaticFailoverStatus;
        private ReshardingStatus resharding;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupPendingModifiedValues model) {
            this.primaryClusterId(model.primaryClusterId);
            this.automaticFailoverStatus(model.automaticFailoverStatus);
            this.resharding(model.resharding);
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final String getAutomaticFailoverStatus() {
            return this.automaticFailoverStatus;
        }

        @Override
        public final Builder automaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
            return this;
        }

        @Override
        public final Builder automaticFailoverStatus(PendingAutomaticFailoverStatus automaticFailoverStatus) {
            this.automaticFailoverStatus(automaticFailoverStatus.toString());
            return this;
        }

        public final void setAutomaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
        }

        public final ReshardingStatus.Builder getResharding() {
            return this.resharding != null ? this.resharding.toBuilder() : null;
        }

        @Override
        public final Builder resharding(ReshardingStatus resharding) {
            this.resharding = resharding;
            return this;
        }

        public final void setResharding(ReshardingStatus.BuilderImpl resharding) {
            this.resharding = resharding != null ? resharding.build() : null;
        }

        public ReplicationGroupPendingModifiedValues build() {
            return new ReplicationGroupPendingModifiedValues(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
        public Builder primaryClusterId(String var1);

        public Builder automaticFailoverStatus(String var1);

        public Builder automaticFailoverStatus(PendingAutomaticFailoverStatus var1);

        public Builder resharding(ReshardingStatus var1);

        default public Builder resharding(Consumer<ReshardingStatus.Builder> resharding) {
            return this.resharding((ReshardingStatus)((ReshardingStatus.Builder)ReshardingStatus.builder().apply(resharding)).build());
        }
    }
}

