/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValue;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyCacheParameterGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ModifyCacheParameterGroupRequest> {
    private final String cacheParameterGroupName;
    private final List<ParameterNameValue> parameterNameValues;

    private ModifyCacheParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.parameterNameValues = builder.parameterNameValues;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public List<ParameterNameValue> parameterNameValues() {
        return this.parameterNameValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterNameValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheParameterGroupRequest)) {
            return false;
        }
        ModifyCacheParameterGroupRequest other = (ModifyCacheParameterGroupRequest)((Object)obj);
        return Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.parameterNameValues(), other.parameterNameValues());
    }

    public String toString() {
        return ToString.builder((String)"ModifyCacheParameterGroupRequest").add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("ParameterNameValues", this.parameterNameValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheParameterGroupName": {
                return Optional.of(clazz.cast(this.cacheParameterGroupName()));
            }
            case "ParameterNameValues": {
                return Optional.of(clazz.cast(this.parameterNameValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheParameterGroupName;
        private List<ParameterNameValue> parameterNameValues;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCacheParameterGroupRequest model) {
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.parameterNameValues(model.parameterNameValues);
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final Collection<ParameterNameValue.Builder> getParameterNameValues() {
            return this.parameterNameValues != null ? (Collection)this.parameterNameValues.stream().map(ParameterNameValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue ... parameterNameValues) {
            this.parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue.BuilderImpl> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copyFromBuilder(parameterNameValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyCacheParameterGroupRequest build() {
            return new ModifyCacheParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, ModifyCacheParameterGroupRequest> {
        public Builder cacheParameterGroupName(String var1);

        public Builder parameterNameValues(Collection<ParameterNameValue> var1);

        public Builder parameterNameValues(ParameterNameValue ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

