/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheClustersRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DescribeCacheClustersRequest> {
    private final String cacheClusterId;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean showCacheNodeInfo;
    private final Boolean showCacheClustersNotInReplicationGroups;

    private DescribeCacheClustersRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.showCacheNodeInfo = builder.showCacheNodeInfo;
        this.showCacheClustersNotInReplicationGroups = builder.showCacheClustersNotInReplicationGroups;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean showCacheNodeInfo() {
        return this.showCacheNodeInfo;
    }

    public Boolean showCacheClustersNotInReplicationGroups() {
        return this.showCacheClustersNotInReplicationGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.showCacheNodeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.showCacheClustersNotInReplicationGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheClustersRequest)) {
            return false;
        }
        DescribeCacheClustersRequest other = (DescribeCacheClustersRequest)((Object)obj);
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.showCacheNodeInfo(), other.showCacheNodeInfo()) && Objects.equals(this.showCacheClustersNotInReplicationGroups(), other.showCacheClustersNotInReplicationGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCacheClustersRequest").add("CacheClusterId", (Object)this.cacheClusterId()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).add("ShowCacheNodeInfo", (Object)this.showCacheNodeInfo()).add("ShowCacheClustersNotInReplicationGroups", (Object)this.showCacheClustersNotInReplicationGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.of(clazz.cast(this.cacheClusterId()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ShowCacheNodeInfo": {
                return Optional.of(clazz.cast(this.showCacheNodeInfo()));
            }
            case "ShowCacheClustersNotInReplicationGroups": {
                return Optional.of(clazz.cast(this.showCacheClustersNotInReplicationGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private Integer maxRecords;
        private String marker;
        private Boolean showCacheNodeInfo;
        private Boolean showCacheClustersNotInReplicationGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheClustersRequest model) {
            this.cacheClusterId(model.cacheClusterId);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.showCacheNodeInfo(model.showCacheNodeInfo);
            this.showCacheClustersNotInReplicationGroups(model.showCacheClustersNotInReplicationGroups);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getShowCacheNodeInfo() {
            return this.showCacheNodeInfo;
        }

        @Override
        public final Builder showCacheNodeInfo(Boolean showCacheNodeInfo) {
            this.showCacheNodeInfo = showCacheNodeInfo;
            return this;
        }

        public final void setShowCacheNodeInfo(Boolean showCacheNodeInfo) {
            this.showCacheNodeInfo = showCacheNodeInfo;
        }

        public final Boolean getShowCacheClustersNotInReplicationGroups() {
            return this.showCacheClustersNotInReplicationGroups;
        }

        @Override
        public final Builder showCacheClustersNotInReplicationGroups(Boolean showCacheClustersNotInReplicationGroups) {
            this.showCacheClustersNotInReplicationGroups = showCacheClustersNotInReplicationGroups;
            return this;
        }

        public final void setShowCacheClustersNotInReplicationGroups(Boolean showCacheClustersNotInReplicationGroups) {
            this.showCacheClustersNotInReplicationGroups = showCacheClustersNotInReplicationGroups;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeCacheClustersRequest build() {
            return new DescribeCacheClustersRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, DescribeCacheClustersRequest> {
        public Builder cacheClusterId(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder showCacheNodeInfo(Boolean var1);

        public Builder showCacheClustersNotInReplicationGroups(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

