/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteReplicationGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DeleteReplicationGroupRequest> {
    private final String replicationGroupId;
    private final Boolean retainPrimaryCluster;
    private final String finalSnapshotIdentifier;

    private DeleteReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.retainPrimaryCluster = builder.retainPrimaryCluster;
        this.finalSnapshotIdentifier = builder.finalSnapshotIdentifier;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public Boolean retainPrimaryCluster() {
        return this.retainPrimaryCluster;
    }

    public String finalSnapshotIdentifier() {
        return this.finalSnapshotIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainPrimaryCluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalSnapshotIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteReplicationGroupRequest)) {
            return false;
        }
        DeleteReplicationGroupRequest other = (DeleteReplicationGroupRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.retainPrimaryCluster(), other.retainPrimaryCluster()) && Objects.equals(this.finalSnapshotIdentifier(), other.finalSnapshotIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"DeleteReplicationGroupRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("RetainPrimaryCluster", (Object)this.retainPrimaryCluster()).add("FinalSnapshotIdentifier", (Object)this.finalSnapshotIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.of(clazz.cast(this.replicationGroupId()));
            }
            case "RetainPrimaryCluster": {
                return Optional.of(clazz.cast(this.retainPrimaryCluster()));
            }
            case "FinalSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.finalSnapshotIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private Boolean retainPrimaryCluster;
        private String finalSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteReplicationGroupRequest model) {
            this.replicationGroupId(model.replicationGroupId);
            this.retainPrimaryCluster(model.retainPrimaryCluster);
            this.finalSnapshotIdentifier(model.finalSnapshotIdentifier);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final Boolean getRetainPrimaryCluster() {
            return this.retainPrimaryCluster;
        }

        @Override
        public final Builder retainPrimaryCluster(Boolean retainPrimaryCluster) {
            this.retainPrimaryCluster = retainPrimaryCluster;
            return this;
        }

        public final void setRetainPrimaryCluster(Boolean retainPrimaryCluster) {
            this.retainPrimaryCluster = retainPrimaryCluster;
        }

        public final String getFinalSnapshotIdentifier() {
            return this.finalSnapshotIdentifier;
        }

        @Override
        public final Builder finalSnapshotIdentifier(String finalSnapshotIdentifier) {
            this.finalSnapshotIdentifier = finalSnapshotIdentifier;
            return this;
        }

        public final void setFinalSnapshotIdentifier(String finalSnapshotIdentifier) {
            this.finalSnapshotIdentifier = finalSnapshotIdentifier;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteReplicationGroupRequest build() {
            return new DeleteReplicationGroupRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, DeleteReplicationGroupRequest> {
        public Builder replicationGroupId(String var1);

        public Builder retainPrimaryCluster(Boolean var1);

        public Builder finalSnapshotIdentifier(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

