/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.KeyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemoveTagsFromResourceRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
    private final String resourceName;
    private final List<String> tagKeys;

    private RemoveTagsFromResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.tagKeys = builder.tagKeys;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromResourceRequest)) {
            return false;
        }
        RemoveTagsFromResourceRequest other = (RemoveTagsFromResourceRequest)((Object)obj);
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.tagKeys(), other.tagKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "TagKeys": {
                return Optional.of(clazz.cast(this.tagKeys()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String resourceName;
        private List<String> tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsFromResourceRequest model) {
            this.resourceName(model.resourceName);
            this.tagKeys(model.tagKeys);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RemoveTagsFromResourceRequest build() {
            return new RemoveTagsFromResourceRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
        public Builder resourceName(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

