/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NodeGroupMember
implements ToCopyableBuilder<Builder, NodeGroupMember> {
    private final String cacheClusterId;
    private final String cacheNodeId;
    private final Endpoint readEndpoint;
    private final String preferredAvailabilityZone;
    private final String currentRole;

    private NodeGroupMember(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.cacheNodeId = builder.cacheNodeId;
        this.readEndpoint = builder.readEndpoint;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.currentRole = builder.currentRole;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String cacheNodeId() {
        return this.cacheNodeId;
    }

    public Endpoint readEndpoint() {
        return this.readEndpoint;
    }

    public String preferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public String currentRole() {
        return this.currentRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.readEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupMember)) {
            return false;
        }
        NodeGroupMember other = (NodeGroupMember)obj;
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.cacheNodeId(), other.cacheNodeId()) && Objects.equals(this.readEndpoint(), other.readEndpoint()) && Objects.equals(this.preferredAvailabilityZone(), other.preferredAvailabilityZone()) && Objects.equals(this.currentRole(), other.currentRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.cacheNodeId() != null) {
            sb.append("CacheNodeId: ").append(this.cacheNodeId()).append(",");
        }
        if (this.readEndpoint() != null) {
            sb.append("ReadEndpoint: ").append(this.readEndpoint()).append(",");
        }
        if (this.preferredAvailabilityZone() != null) {
            sb.append("PreferredAvailabilityZone: ").append(this.preferredAvailabilityZone()).append(",");
        }
        if (this.currentRole() != null) {
            sb.append("CurrentRole: ").append(this.currentRole()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.of(clazz.cast(this.cacheClusterId()));
            }
            case "CacheNodeId": {
                return Optional.of(clazz.cast(this.cacheNodeId()));
            }
            case "ReadEndpoint": {
                return Optional.of(clazz.cast(this.readEndpoint()));
            }
            case "PreferredAvailabilityZone": {
                return Optional.of(clazz.cast(this.preferredAvailabilityZone()));
            }
            case "CurrentRole": {
                return Optional.of(clazz.cast(this.currentRole()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private String cacheNodeId;
        private Endpoint readEndpoint;
        private String preferredAvailabilityZone;
        private String currentRole;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupMember model) {
            this.cacheClusterId(model.cacheClusterId);
            this.cacheNodeId(model.cacheNodeId);
            this.readEndpoint(model.readEndpoint);
            this.preferredAvailabilityZone(model.preferredAvailabilityZone);
            this.currentRole(model.currentRole);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getCacheNodeId() {
            return this.cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        public final Endpoint.Builder getReadEndpoint() {
            return this.readEndpoint != null ? this.readEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder readEndpoint(Endpoint readEndpoint) {
            this.readEndpoint = readEndpoint;
            return this;
        }

        public final void setReadEndpoint(Endpoint.BuilderImpl readEndpoint) {
            this.readEndpoint = readEndpoint != null ? readEndpoint.build() : null;
        }

        public final String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        public final String getCurrentRole() {
            return this.currentRole;
        }

        @Override
        public final Builder currentRole(String currentRole) {
            this.currentRole = currentRole;
            return this;
        }

        public final void setCurrentRole(String currentRole) {
            this.currentRole = currentRole;
        }

        public NodeGroupMember build() {
            return new NodeGroupMember(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NodeGroupMember> {
        public Builder cacheClusterId(String var1);

        public Builder cacheNodeId(String var1);

        public Builder readEndpoint(Endpoint var1);

        default public Builder readEndpoint(Consumer<Endpoint.Builder> readEndpoint) {
            return this.readEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().apply(readEndpoint)).build());
        }

        public Builder preferredAvailabilityZone(String var1);

        public Builder currentRole(String var1);
    }
}

