/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSnapshotsRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DescribeSnapshotsRequest> {
    private final String replicationGroupId;
    private final String cacheClusterId;
    private final String snapshotName;
    private final String snapshotSource;
    private final String marker;
    private final Integer maxRecords;
    private final Boolean showNodeGroupConfig;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.cacheClusterId = builder.cacheClusterId;
        this.snapshotName = builder.snapshotName;
        this.snapshotSource = builder.snapshotSource;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
        this.showNodeGroupConfig = builder.showNodeGroupConfig;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String snapshotSource() {
        return this.snapshotSource;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public Boolean showNodeGroupConfig() {
        return this.showNodeGroupConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.showNodeGroupConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.snapshotSource(), other.snapshotSource()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.showNodeGroupConfig(), other.showNodeGroupConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.snapshotName() != null) {
            sb.append("SnapshotName: ").append(this.snapshotName()).append(",");
        }
        if (this.snapshotSource() != null) {
            sb.append("SnapshotSource: ").append(this.snapshotSource()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.showNodeGroupConfig() != null) {
            sb.append("ShowNodeGroupConfig: ").append(this.showNodeGroupConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.of(clazz.cast(this.replicationGroupId()));
            }
            case "CacheClusterId": {
                return Optional.of(clazz.cast(this.cacheClusterId()));
            }
            case "SnapshotName": {
                return Optional.of(clazz.cast(this.snapshotName()));
            }
            case "SnapshotSource": {
                return Optional.of(clazz.cast(this.snapshotSource()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "ShowNodeGroupConfig": {
                return Optional.of(clazz.cast(this.showNodeGroupConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String cacheClusterId;
        private String snapshotName;
        private String snapshotSource;
        private String marker;
        private Integer maxRecords;
        private Boolean showNodeGroupConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            this.replicationGroupId(model.replicationGroupId);
            this.cacheClusterId(model.cacheClusterId);
            this.snapshotName(model.snapshotName);
            this.snapshotSource(model.snapshotSource);
            this.marker(model.marker);
            this.maxRecords(model.maxRecords);
            this.showNodeGroupConfig(model.showNodeGroupConfig);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getSnapshotSource() {
            return this.snapshotSource;
        }

        @Override
        public final Builder snapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
            return this;
        }

        public final void setSnapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final Boolean getShowNodeGroupConfig() {
            return this.showNodeGroupConfig;
        }

        @Override
        public final Builder showNodeGroupConfig(Boolean showNodeGroupConfig) {
            this.showNodeGroupConfig = showNodeGroupConfig;
            return this;
        }

        public final void setShowNodeGroupConfig(Boolean showNodeGroupConfig) {
            this.showNodeGroupConfig = showNodeGroupConfig;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        public Builder replicationGroupId(String var1);

        public Builder cacheClusterId(String var1);

        public Builder snapshotName(String var1);

        public Builder snapshotSource(String var1);

        public Builder marker(String var1);

        public Builder maxRecords(Integer var1);

        public Builder showNodeGroupConfig(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

