/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNode;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedCacheNodesResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeReservedCacheNodesResponse> {
    private final String marker;
    private final List<ReservedCacheNode> reservedCacheNodes;

    private DescribeReservedCacheNodesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedCacheNodes = builder.reservedCacheNodes;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedCacheNode> reservedCacheNodes() {
        return this.reservedCacheNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCacheNodes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCacheNodesResponse)) {
            return false;
        }
        DescribeReservedCacheNodesResponse other = (DescribeReservedCacheNodesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.reservedCacheNodes(), other.reservedCacheNodes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.reservedCacheNodes() != null) {
            sb.append("ReservedCacheNodes: ").append(this.reservedCacheNodes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ReservedCacheNodes": {
                return Optional.of(clazz.cast(this.reservedCacheNodes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedCacheNode> reservedCacheNodes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCacheNodesResponse model) {
            this.marker(model.marker);
            this.reservedCacheNodes(model.reservedCacheNodes);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedCacheNode.Builder> getReservedCacheNodes() {
            return this.reservedCacheNodes != null ? (Collection)this.reservedCacheNodes.stream().map(ReservedCacheNode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedCacheNodes(Collection<ReservedCacheNode> reservedCacheNodes) {
            this.reservedCacheNodes = ReservedCacheNodeListCopier.copy(reservedCacheNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCacheNodes(ReservedCacheNode ... reservedCacheNodes) {
            this.reservedCacheNodes(Arrays.asList(reservedCacheNodes));
            return this;
        }

        public final void setReservedCacheNodes(Collection<ReservedCacheNode.BuilderImpl> reservedCacheNodes) {
            this.reservedCacheNodes = ReservedCacheNodeListCopier.copyFromBuilder(reservedCacheNodes);
        }

        @Override
        public DescribeReservedCacheNodesResponse build() {
            return new DescribeReservedCacheNodesResponse(this);
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    CopyableBuilder<Builder, DescribeReservedCacheNodesResponse> {
        public Builder marker(String var1);

        public Builder reservedCacheNodes(Collection<ReservedCacheNode> var1);

        public Builder reservedCacheNodes(ReservedCacheNode ... var1);
    }
}

