/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroup;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheParameterGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeCacheParameterGroupsResponse> {
    private final String marker;
    private final List<CacheParameterGroup> cacheParameterGroups;

    private DescribeCacheParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheParameterGroups = builder.cacheParameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheParameterGroup> cacheParameterGroups() {
        return this.cacheParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheParameterGroupsResponse)) {
            return false;
        }
        DescribeCacheParameterGroupsResponse other = (DescribeCacheParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.cacheParameterGroups(), other.cacheParameterGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.cacheParameterGroups() != null) {
            sb.append("CacheParameterGroups: ").append(this.cacheParameterGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "CacheParameterGroups": {
                return Optional.of(clazz.cast(this.cacheParameterGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheParameterGroup> cacheParameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheParameterGroupsResponse model) {
            this.marker(model.marker);
            this.cacheParameterGroups(model.cacheParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheParameterGroup.Builder> getCacheParameterGroups() {
            return this.cacheParameterGroups != null ? (Collection)this.cacheParameterGroups.stream().map(CacheParameterGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheParameterGroups(Collection<CacheParameterGroup> cacheParameterGroups) {
            this.cacheParameterGroups = CacheParameterGroupListCopier.copy(cacheParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheParameterGroups(CacheParameterGroup ... cacheParameterGroups) {
            this.cacheParameterGroups(Arrays.asList(cacheParameterGroups));
            return this;
        }

        public final void setCacheParameterGroups(Collection<CacheParameterGroup.BuilderImpl> cacheParameterGroups) {
            this.cacheParameterGroups = CacheParameterGroupListCopier.copyFromBuilder(cacheParameterGroups);
        }

        @Override
        public DescribeCacheParameterGroupsResponse build() {
            return new DescribeCacheParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    CopyableBuilder<Builder, DescribeCacheParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder cacheParameterGroups(Collection<CacheParameterGroup> var1);

        public Builder cacheParameterGroups(CacheParameterGroup ... var1);
    }
}

