/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.CacheClusterListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheClustersResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeCacheClustersResponse> {
    private final String marker;
    private final List<CacheCluster> cacheClusters;

    private DescribeCacheClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheClusters = builder.cacheClusters;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheCluster> cacheClusters() {
        return this.cacheClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheClustersResponse)) {
            return false;
        }
        DescribeCacheClustersResponse other = (DescribeCacheClustersResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.cacheClusters(), other.cacheClusters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.cacheClusters() != null) {
            sb.append("CacheClusters: ").append(this.cacheClusters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "CacheClusters": {
                return Optional.of(clazz.cast(this.cacheClusters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheCluster> cacheClusters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheClustersResponse model) {
            this.marker(model.marker);
            this.cacheClusters(model.cacheClusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheCluster.Builder> getCacheClusters() {
            return this.cacheClusters != null ? (Collection)this.cacheClusters.stream().map(CacheCluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheClusters(Collection<CacheCluster> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copy(cacheClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusters(CacheCluster ... cacheClusters) {
            this.cacheClusters(Arrays.asList(cacheClusters));
            return this;
        }

        public final void setCacheClusters(Collection<CacheCluster.BuilderImpl> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copyFromBuilder(cacheClusters);
        }

        @Override
        public DescribeCacheClustersResponse build() {
            return new DescribeCacheClustersResponse(this);
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    CopyableBuilder<Builder, DescribeCacheClustersResponse> {
        public Builder marker(String var1);

        public Builder cacheClusters(Collection<CacheCluster> var1);

        public Builder cacheClusters(CacheCluster ... var1);
    }
}

