/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest;

public class CreateCacheParameterGroupRequestMarshaller
implements Marshaller<Request<CreateCacheParameterGroupRequest>, CreateCacheParameterGroupRequest> {
    public Request<CreateCacheParameterGroupRequest> marshall(CreateCacheParameterGroupRequest createCacheParameterGroupRequest) {
        if (createCacheParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCacheParameterGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateCacheParameterGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCacheParameterGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)createCacheParameterGroupRequest.cacheParameterGroupName()));
        }
        if (createCacheParameterGroupRequest.cacheParameterGroupFamily() != null) {
            request.addParameter("CacheParameterGroupFamily", StringUtils.fromString((String)createCacheParameterGroupRequest.cacheParameterGroupFamily()));
        }
        if (createCacheParameterGroupRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createCacheParameterGroupRequest.description()));
        }
        return request;
    }
}

