/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZone;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subnet
implements ToCopyableBuilder<Builder, Subnet> {
    private final String subnetIdentifier;
    private final AvailabilityZone subnetAvailabilityZone;

    private Subnet(BuilderImpl builder) {
        this.subnetIdentifier = builder.subnetIdentifier;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
    }

    public String subnetIdentifier() {
        return this.subnetIdentifier;
    }

    public AvailabilityZone subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetAvailabilityZone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return Objects.equals(this.subnetIdentifier(), other.subnetIdentifier()) && Objects.equals(this.subnetAvailabilityZone(), other.subnetAvailabilityZone());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subnetIdentifier() != null) {
            sb.append("SubnetIdentifier: ").append(this.subnetIdentifier()).append(",");
        }
        if (this.subnetAvailabilityZone() != null) {
            sb.append("SubnetAvailabilityZone: ").append(this.subnetAvailabilityZone()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIdentifier": {
                return Optional.of(clazz.cast(this.subnetIdentifier()));
            }
            case "SubnetAvailabilityZone": {
                return Optional.of(clazz.cast(this.subnetAvailabilityZone()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetIdentifier;
        private AvailabilityZone subnetAvailabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.subnetIdentifier(model.subnetIdentifier);
            this.subnetAvailabilityZone(model.subnetAvailabilityZone);
        }

        public final String getSubnetIdentifier() {
            return this.subnetIdentifier;
        }

        @Override
        public final Builder subnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
            return this;
        }

        public final void setSubnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
        }

        public final AvailabilityZone.Builder getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone != null ? this.subnetAvailabilityZone.toBuilder() : null;
        }

        @Override
        public final Builder subnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final void setSubnetAvailabilityZone(AvailabilityZone.BuilderImpl subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone != null ? subnetAvailabilityZone.build() : null;
        }

        public Subnet build() {
            return new Subnet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subnet> {
        public Builder subnetIdentifier(String var1);

        public Builder subnetAvailabilityZone(AvailabilityZone var1);

        default public Builder subnetAvailabilityZone(Consumer<AvailabilityZone.Builder> subnetAvailabilityZone) {
            return this.subnetAvailabilityZone((AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().apply(subnetAvailabilityZone)).build());
        }
    }
}

