/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddTagsToResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddTagsToResourceRequest> {
    private final String resourceName;
    private final List<Tag> tags;

    private AddTagsToResourceRequest(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.tags = builder.tags;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToResourceRequest)) {
            return false;
        }
        AddTagsToResourceRequest other = (AddTagsToResourceRequest)((Object)obj);
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsToResourceRequest model) {
            this.resourceName(model.resourceName);
            this.tags(model.tags);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public AddTagsToResourceRequest build() {
            return new AddTagsToResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddTagsToResourceRequest> {
        public Builder resourceName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

