/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValue;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest;

public class ResetCacheParameterGroupRequestMarshaller
implements Marshaller<Request<ResetCacheParameterGroupRequest>, ResetCacheParameterGroupRequest> {
    public Request<ResetCacheParameterGroupRequest> marshall(ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) {
        List<ParameterNameValue> parameterNameValuesList;
        if (resetCacheParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resetCacheParameterGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ResetCacheParameterGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetCacheParameterGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)resetCacheParameterGroupRequest.cacheParameterGroupName()));
        }
        if (resetCacheParameterGroupRequest.resetAllParameters() != null) {
            request.addParameter("ResetAllParameters", StringUtils.fromBoolean((Boolean)resetCacheParameterGroupRequest.resetAllParameters()));
        }
        if ((parameterNameValuesList = resetCacheParameterGroupRequest.parameterNameValues()) != null) {
            if (!parameterNameValuesList.isEmpty()) {
                int parameterNameValuesListIndex = 1;
                for (ParameterNameValue parameterNameValuesListValue : parameterNameValuesList) {
                    if (parameterNameValuesListValue.parameterName() != null) {
                        request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterName", StringUtils.fromString((String)parameterNameValuesListValue.parameterName()));
                    }
                    if (parameterNameValuesListValue.parameterValue() != null) {
                        request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterValue", StringUtils.fromString((String)parameterNameValuesListValue.parameterValue()));
                    }
                    ++parameterNameValuesListIndex;
                }
            } else {
                request.addParameter("ParameterNameValues", "");
            }
        }
        return request;
    }
}

