/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest;

public class DeleteSnapshotRequestMarshaller
implements Marshaller<Request<DeleteSnapshotRequest>, DeleteSnapshotRequest> {
    public Request<DeleteSnapshotRequest> marshall(DeleteSnapshotRequest deleteSnapshotRequest) {
        if (deleteSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteSnapshotRequest, "ElastiCacheClient");
        request.addParameter("Action", "DeleteSnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSnapshotRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)deleteSnapshotRequest.snapshotName()));
        }
        return request;
    }
}

