/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest;

public class CreateSnapshotRequestMarshaller
implements Marshaller<Request<CreateSnapshotRequest>, CreateSnapshotRequest> {
    public Request<CreateSnapshotRequest> marshall(CreateSnapshotRequest createSnapshotRequest) {
        if (createSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSnapshotRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateSnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)createSnapshotRequest.replicationGroupId()));
        }
        if (createSnapshotRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)createSnapshotRequest.cacheClusterId()));
        }
        if (createSnapshotRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)createSnapshotRequest.snapshotName()));
        }
        return request;
    }
}

