/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Optional;
import software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReplicationGroupPendingModifiedValues
implements ToCopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
    private final String primaryClusterId;
    private final String automaticFailoverStatus;

    private ReplicationGroupPendingModifiedValues(BuilderImpl builder) {
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverStatus = builder.automaticFailoverStatus;
    }

    public String primaryClusterId() {
        return this.primaryClusterId;
    }

    public PendingAutomaticFailoverStatus automaticFailoverStatus() {
        return PendingAutomaticFailoverStatus.fromValue(this.automaticFailoverStatus);
    }

    public String automaticFailoverStatusString() {
        return this.automaticFailoverStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.primaryClusterId() == null ? 0 : this.primaryClusterId().hashCode());
        hashCode = 31 * hashCode + (this.automaticFailoverStatusString() == null ? 0 : this.automaticFailoverStatusString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupPendingModifiedValues)) {
            return false;
        }
        ReplicationGroupPendingModifiedValues other = (ReplicationGroupPendingModifiedValues)obj;
        if (other.primaryClusterId() == null ^ this.primaryClusterId() == null) {
            return false;
        }
        if (other.primaryClusterId() != null && !other.primaryClusterId().equals(this.primaryClusterId())) {
            return false;
        }
        if (other.automaticFailoverStatusString() == null ^ this.automaticFailoverStatusString() == null) {
            return false;
        }
        return other.automaticFailoverStatusString() == null || other.automaticFailoverStatusString().equals(this.automaticFailoverStatusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.primaryClusterId() != null) {
            sb.append("PrimaryClusterId: ").append(this.primaryClusterId()).append(",");
        }
        if (this.automaticFailoverStatusString() != null) {
            sb.append("AutomaticFailoverStatus: ").append(this.automaticFailoverStatusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryClusterId": {
                return Optional.of(clazz.cast(this.primaryClusterId()));
            }
            case "AutomaticFailoverStatus": {
                return Optional.of(clazz.cast(this.automaticFailoverStatusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryClusterId;
        private String automaticFailoverStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupPendingModifiedValues model) {
            this.primaryClusterId(model.primaryClusterId);
            this.automaticFailoverStatus(model.automaticFailoverStatus);
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final String getAutomaticFailoverStatus() {
            return this.automaticFailoverStatus;
        }

        @Override
        public final Builder automaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
            return this;
        }

        @Override
        public final Builder automaticFailoverStatus(PendingAutomaticFailoverStatus automaticFailoverStatus) {
            this.automaticFailoverStatus(automaticFailoverStatus.toString());
            return this;
        }

        public final void setAutomaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
        }

        public ReplicationGroupPendingModifiedValues build() {
            return new ReplicationGroupPendingModifiedValues(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
        public Builder primaryClusterId(String var1);

        public Builder automaticFailoverStatus(String var1);

        public Builder automaticFailoverStatus(PendingAutomaticFailoverStatus var1);
    }
}

