/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticache.model.AZMode;
import software.amazon.awssdk.services.elasticache.model.CacheNodeIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.PreferredAvailabilityZoneListCopier;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyCacheClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyCacheClusterRequest> {
    private final String cacheClusterId;
    private final Integer numCacheNodes;
    private final List<String> cacheNodeIdsToRemove;
    private final String azMode;
    private final List<String> newAvailabilityZones;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final String preferredMaintenanceWindow;
    private final String notificationTopicArn;
    private final String cacheParameterGroupName;
    private final String notificationTopicStatus;
    private final Boolean applyImmediately;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String cacheNodeType;

    private ModifyCacheClusterRequest(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeIdsToRemove = builder.cacheNodeIdsToRemove;
        this.azMode = builder.azMode;
        this.newAvailabilityZones = builder.newAvailabilityZones;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.applyImmediately = builder.applyImmediately;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.cacheNodeType = builder.cacheNodeType;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public List<String> cacheNodeIdsToRemove() {
        return this.cacheNodeIdsToRemove;
    }

    public AZMode azMode() {
        return AZMode.fromValue(this.azMode);
    }

    public String azModeString() {
        return this.azMode;
    }

    public List<String> newAvailabilityZones() {
        return this.newAvailabilityZones;
    }

    public List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String notificationTopicStatus() {
        return this.notificationTopicStatus;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheClusterId() == null ? 0 : this.cacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.numCacheNodes() == null ? 0 : this.numCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeIdsToRemove() == null ? 0 : this.cacheNodeIdsToRemove().hashCode());
        hashCode = 31 * hashCode + (this.azModeString() == null ? 0 : this.azModeString().hashCode());
        hashCode = 31 * hashCode + (this.newAvailabilityZones() == null ? 0 : this.newAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.cacheSecurityGroupNames() == null ? 0 : this.cacheSecurityGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.notificationTopicArn() == null ? 0 : this.notificationTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.cacheParameterGroupName() == null ? 0 : this.cacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.notificationTopicStatus() == null ? 0 : this.notificationTopicStatus().hashCode());
        hashCode = 31 * hashCode + (this.applyImmediately() == null ? 0 : this.applyImmediately().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.autoMinorVersionUpgrade() == null ? 0 : this.autoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.snapshotRetentionLimit() == null ? 0 : this.snapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.snapshotWindow() == null ? 0 : this.snapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeType() == null ? 0 : this.cacheNodeType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheClusterRequest)) {
            return false;
        }
        ModifyCacheClusterRequest other = (ModifyCacheClusterRequest)((Object)obj);
        if (other.cacheClusterId() == null ^ this.cacheClusterId() == null) {
            return false;
        }
        if (other.cacheClusterId() != null && !other.cacheClusterId().equals(this.cacheClusterId())) {
            return false;
        }
        if (other.numCacheNodes() == null ^ this.numCacheNodes() == null) {
            return false;
        }
        if (other.numCacheNodes() != null && !other.numCacheNodes().equals(this.numCacheNodes())) {
            return false;
        }
        if (other.cacheNodeIdsToRemove() == null ^ this.cacheNodeIdsToRemove() == null) {
            return false;
        }
        if (other.cacheNodeIdsToRemove() != null && !other.cacheNodeIdsToRemove().equals(this.cacheNodeIdsToRemove())) {
            return false;
        }
        if (other.azModeString() == null ^ this.azModeString() == null) {
            return false;
        }
        if (other.azModeString() != null && !other.azModeString().equals(this.azModeString())) {
            return false;
        }
        if (other.newAvailabilityZones() == null ^ this.newAvailabilityZones() == null) {
            return false;
        }
        if (other.newAvailabilityZones() != null && !other.newAvailabilityZones().equals(this.newAvailabilityZones())) {
            return false;
        }
        if (other.cacheSecurityGroupNames() == null ^ this.cacheSecurityGroupNames() == null) {
            return false;
        }
        if (other.cacheSecurityGroupNames() != null && !other.cacheSecurityGroupNames().equals(this.cacheSecurityGroupNames())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.notificationTopicArn() == null ^ this.notificationTopicArn() == null) {
            return false;
        }
        if (other.notificationTopicArn() != null && !other.notificationTopicArn().equals(this.notificationTopicArn())) {
            return false;
        }
        if (other.cacheParameterGroupName() == null ^ this.cacheParameterGroupName() == null) {
            return false;
        }
        if (other.cacheParameterGroupName() != null && !other.cacheParameterGroupName().equals(this.cacheParameterGroupName())) {
            return false;
        }
        if (other.notificationTopicStatus() == null ^ this.notificationTopicStatus() == null) {
            return false;
        }
        if (other.notificationTopicStatus() != null && !other.notificationTopicStatus().equals(this.notificationTopicStatus())) {
            return false;
        }
        if (other.applyImmediately() == null ^ this.applyImmediately() == null) {
            return false;
        }
        if (other.applyImmediately() != null && !other.applyImmediately().equals(this.applyImmediately())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() == null ^ this.autoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() != null && !other.autoMinorVersionUpgrade().equals(this.autoMinorVersionUpgrade())) {
            return false;
        }
        if (other.snapshotRetentionLimit() == null ^ this.snapshotRetentionLimit() == null) {
            return false;
        }
        if (other.snapshotRetentionLimit() != null && !other.snapshotRetentionLimit().equals(this.snapshotRetentionLimit())) {
            return false;
        }
        if (other.snapshotWindow() == null ^ this.snapshotWindow() == null) {
            return false;
        }
        if (other.snapshotWindow() != null && !other.snapshotWindow().equals(this.snapshotWindow())) {
            return false;
        }
        if (other.cacheNodeType() == null ^ this.cacheNodeType() == null) {
            return false;
        }
        return other.cacheNodeType() == null || other.cacheNodeType().equals(this.cacheNodeType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.numCacheNodes() != null) {
            sb.append("NumCacheNodes: ").append(this.numCacheNodes()).append(",");
        }
        if (this.cacheNodeIdsToRemove() != null) {
            sb.append("CacheNodeIdsToRemove: ").append(this.cacheNodeIdsToRemove()).append(",");
        }
        if (this.azModeString() != null) {
            sb.append("AZMode: ").append(this.azModeString()).append(",");
        }
        if (this.newAvailabilityZones() != null) {
            sb.append("NewAvailabilityZones: ").append(this.newAvailabilityZones()).append(",");
        }
        if (this.cacheSecurityGroupNames() != null) {
            sb.append("CacheSecurityGroupNames: ").append(this.cacheSecurityGroupNames()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.notificationTopicArn() != null) {
            sb.append("NotificationTopicArn: ").append(this.notificationTopicArn()).append(",");
        }
        if (this.cacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.cacheParameterGroupName()).append(",");
        }
        if (this.notificationTopicStatus() != null) {
            sb.append("NotificationTopicStatus: ").append(this.notificationTopicStatus()).append(",");
        }
        if (this.applyImmediately() != null) {
            sb.append("ApplyImmediately: ").append(this.applyImmediately()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.snapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.snapshotRetentionLimit()).append(",");
        }
        if (this.snapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.snapshotWindow()).append(",");
        }
        if (this.cacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.cacheNodeType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.of(clazz.cast(this.cacheClusterId()));
            }
            case "NumCacheNodes": {
                return Optional.of(clazz.cast(this.numCacheNodes()));
            }
            case "CacheNodeIdsToRemove": {
                return Optional.of(clazz.cast(this.cacheNodeIdsToRemove()));
            }
            case "AZMode": {
                return Optional.of(clazz.cast(this.azModeString()));
            }
            case "NewAvailabilityZones": {
                return Optional.of(clazz.cast(this.newAvailabilityZones()));
            }
            case "CacheSecurityGroupNames": {
                return Optional.of(clazz.cast(this.cacheSecurityGroupNames()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "NotificationTopicArn": {
                return Optional.of(clazz.cast(this.notificationTopicArn()));
            }
            case "CacheParameterGroupName": {
                return Optional.of(clazz.cast(this.cacheParameterGroupName()));
            }
            case "NotificationTopicStatus": {
                return Optional.of(clazz.cast(this.notificationTopicStatus()));
            }
            case "ApplyImmediately": {
                return Optional.of(clazz.cast(this.applyImmediately()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.of(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.of(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.of(clazz.cast(this.snapshotWindow()));
            }
            case "CacheNodeType": {
                return Optional.of(clazz.cast(this.cacheNodeType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private Integer numCacheNodes;
        private List<String> cacheNodeIdsToRemove;
        private String azMode;
        private List<String> newAvailabilityZones;
        private List<String> cacheSecurityGroupNames;
        private List<String> securityGroupIds;
        private String preferredMaintenanceWindow;
        private String notificationTopicArn;
        private String cacheParameterGroupName;
        private String notificationTopicStatus;
        private Boolean applyImmediately;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String cacheNodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCacheClusterRequest model) {
            this.cacheClusterId(model.cacheClusterId);
            this.numCacheNodes(model.numCacheNodes);
            this.cacheNodeIdsToRemove(model.cacheNodeIdsToRemove);
            this.azMode(model.azMode);
            this.newAvailabilityZones(model.newAvailabilityZones);
            this.cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.securityGroupIds(model.securityGroupIds);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.notificationTopicArn(model.notificationTopicArn);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.notificationTopicStatus(model.notificationTopicStatus);
            this.applyImmediately(model.applyImmediately);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.cacheNodeType(model.cacheNodeType);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final Collection<String> getCacheNodeIdsToRemove() {
            return this.cacheNodeIdsToRemove;
        }

        @Override
        public final Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToRemove(String ... cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove(Arrays.asList(cacheNodeIdsToRemove));
            return this;
        }

        public final void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
        }

        public final String getAZMode() {
            return this.azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(AZMode azMode) {
            this.azMode(azMode.toString());
            return this;
        }

        public final void setAZMode(String azMode) {
            this.azMode = azMode;
        }

        public final Collection<String> getNewAvailabilityZones() {
            return this.newAvailabilityZones;
        }

        @Override
        public final Builder newAvailabilityZones(Collection<String> newAvailabilityZones) {
            this.newAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(newAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newAvailabilityZones(String ... newAvailabilityZones) {
            this.newAvailabilityZones(Arrays.asList(newAvailabilityZones));
            return this;
        }

        public final void setNewAvailabilityZones(Collection<String> newAvailabilityZones) {
            this.newAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(newAvailabilityZones);
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getNotificationTopicStatus() {
            return this.notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public ModifyCacheClusterRequest build() {
            return new ModifyCacheClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyCacheClusterRequest> {
        public Builder cacheClusterId(String var1);

        public Builder numCacheNodes(Integer var1);

        public Builder cacheNodeIdsToRemove(Collection<String> var1);

        public Builder cacheNodeIdsToRemove(String ... var1);

        public Builder azMode(String var1);

        public Builder azMode(AZMode var1);

        public Builder newAvailabilityZones(Collection<String> var1);

        public Builder newAvailabilityZones(String ... var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder notificationTopicArn(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder notificationTopicStatus(String var1);

        public Builder applyImmediately(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder cacheNodeType(String var1);
    }
}

