/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEngineDefaultParametersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeEngineDefaultParametersRequest> {
    private final String cacheParameterGroupFamily;
    private final Integer maxRecords;
    private final String marker;

    private DescribeEngineDefaultParametersRequest(BuilderImpl builder) {
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String cacheParameterGroupFamily() {
        return this.cacheParameterGroupFamily;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheParameterGroupFamily() == null ? 0 : this.cacheParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEngineDefaultParametersRequest)) {
            return false;
        }
        DescribeEngineDefaultParametersRequest other = (DescribeEngineDefaultParametersRequest)((Object)obj);
        if (other.cacheParameterGroupFamily() == null ^ this.cacheParameterGroupFamily() == null) {
            return false;
        }
        if (other.cacheParameterGroupFamily() != null && !other.cacheParameterGroupFamily().equals(this.cacheParameterGroupFamily())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cacheParameterGroupFamily() != null) {
            sb.append("CacheParameterGroupFamily: ").append(this.cacheParameterGroupFamily()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheParameterGroupFamily": {
                return Optional.of(clazz.cast(this.cacheParameterGroupFamily()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheParameterGroupFamily;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEngineDefaultParametersRequest model) {
            this.cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getCacheParameterGroupFamily() {
            return this.cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeEngineDefaultParametersRequest build() {
            return new DescribeEngineDefaultParametersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEngineDefaultParametersRequest> {
        public Builder cacheParameterGroupFamily(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);
    }
}

