/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheSubnetGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCacheSubnetGroupsResponse> {
    private final String marker;
    private final List<CacheSubnetGroup> cacheSubnetGroups;

    private DescribeCacheSubnetGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.cacheSubnetGroups = builder.cacheSubnetGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheSubnetGroup> cacheSubnetGroups() {
        return this.cacheSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.cacheSubnetGroups() == null ? 0 : this.cacheSubnetGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheSubnetGroupsResponse)) {
            return false;
        }
        DescribeCacheSubnetGroupsResponse other = (DescribeCacheSubnetGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.cacheSubnetGroups() == null ^ this.cacheSubnetGroups() == null) {
            return false;
        }
        return other.cacheSubnetGroups() == null || other.cacheSubnetGroups().equals(this.cacheSubnetGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.cacheSubnetGroups() != null) {
            sb.append("CacheSubnetGroups: ").append(this.cacheSubnetGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "CacheSubnetGroups": {
                return Optional.of(clazz.cast(this.cacheSubnetGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheSubnetGroup> cacheSubnetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheSubnetGroupsResponse model) {
            this.marker(model.marker);
            this.cacheSubnetGroups(model.cacheSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheSubnetGroup.Builder> getCacheSubnetGroups() {
            return this.cacheSubnetGroups != null ? (Collection)this.cacheSubnetGroups.stream().map(CacheSubnetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheSubnetGroups(Collection<CacheSubnetGroup> cacheSubnetGroups) {
            this.cacheSubnetGroups = CacheSubnetGroupsCopier.copy(cacheSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSubnetGroups(CacheSubnetGroup ... cacheSubnetGroups) {
            this.cacheSubnetGroups(Arrays.asList(cacheSubnetGroups));
            return this;
        }

        public final void setCacheSubnetGroups(Collection<CacheSubnetGroup.BuilderImpl> cacheSubnetGroups) {
            this.cacheSubnetGroups = CacheSubnetGroupsCopier.copyFromBuilder(cacheSubnetGroups);
        }

        public DescribeCacheSubnetGroupsResponse build() {
            return new DescribeCacheSubnetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCacheSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder cacheSubnetGroups(Collection<CacheSubnetGroup> var1);

        public Builder cacheSubnetGroups(CacheSubnetGroup ... var1);
    }
}

