/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateSnapshotRequest> {
    private final String replicationGroupId;
    private final String cacheClusterId;
    private final String snapshotName;

    private CreateSnapshotRequest(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.cacheClusterId = builder.cacheClusterId;
        this.snapshotName = builder.snapshotName;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.replicationGroupId() == null ? 0 : this.replicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.cacheClusterId() == null ? 0 : this.cacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.snapshotName() == null ? 0 : this.snapshotName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest)((Object)obj);
        if (other.replicationGroupId() == null ^ this.replicationGroupId() == null) {
            return false;
        }
        if (other.replicationGroupId() != null && !other.replicationGroupId().equals(this.replicationGroupId())) {
            return false;
        }
        if (other.cacheClusterId() == null ^ this.cacheClusterId() == null) {
            return false;
        }
        if (other.cacheClusterId() != null && !other.cacheClusterId().equals(this.cacheClusterId())) {
            return false;
        }
        if (other.snapshotName() == null ^ this.snapshotName() == null) {
            return false;
        }
        return other.snapshotName() == null || other.snapshotName().equals(this.snapshotName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.snapshotName() != null) {
            sb.append("SnapshotName: ").append(this.snapshotName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.of(clazz.cast(this.replicationGroupId()));
            }
            case "CacheClusterId": {
                return Optional.of(clazz.cast(this.cacheClusterId()));
            }
            case "SnapshotName": {
                return Optional.of(clazz.cast(this.snapshotName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String cacheClusterId;
        private String snapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotRequest model) {
            this.replicationGroupId(model.replicationGroupId);
            this.cacheClusterId(model.cacheClusterId);
            this.snapshotName(model.snapshotName);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public CreateSnapshotRequest build() {
            return new CreateSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateSnapshotRequest> {
        public Builder replicationGroupId(String var1);

        public Builder cacheClusterId(String var1);

        public Builder snapshotName(String var1);
    }
}

