/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticache.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateCacheSubnetGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateCacheSubnetGroupRequest> {
    private final String cacheSubnetGroupName;
    private final String cacheSubnetGroupDescription;
    private final List<String> subnetIds;

    private CreateCacheSubnetGroupRequest(BuilderImpl builder) {
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSubnetGroupDescription = builder.cacheSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public String cacheSubnetGroupDescription() {
        return this.cacheSubnetGroupDescription;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheSubnetGroupName() == null ? 0 : this.cacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.cacheSubnetGroupDescription() == null ? 0 : this.cacheSubnetGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheSubnetGroupRequest)) {
            return false;
        }
        CreateCacheSubnetGroupRequest other = (CreateCacheSubnetGroupRequest)((Object)obj);
        if (other.cacheSubnetGroupName() == null ^ this.cacheSubnetGroupName() == null) {
            return false;
        }
        if (other.cacheSubnetGroupName() != null && !other.cacheSubnetGroupName().equals(this.cacheSubnetGroupName())) {
            return false;
        }
        if (other.cacheSubnetGroupDescription() == null ^ this.cacheSubnetGroupDescription() == null) {
            return false;
        }
        if (other.cacheSubnetGroupDescription() != null && !other.cacheSubnetGroupDescription().equals(this.cacheSubnetGroupDescription())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        return other.subnetIds() == null || other.subnetIds().equals(this.subnetIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: ").append(this.cacheSubnetGroupName()).append(",");
        }
        if (this.cacheSubnetGroupDescription() != null) {
            sb.append("CacheSubnetGroupDescription: ").append(this.cacheSubnetGroupDescription()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheSubnetGroupName": {
                return Optional.of(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "CacheSubnetGroupDescription": {
                return Optional.of(clazz.cast(this.cacheSubnetGroupDescription()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheSubnetGroupName;
        private String cacheSubnetGroupDescription;
        private List<String> subnetIds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCacheSubnetGroupRequest model) {
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.cacheSubnetGroupDescription(model.cacheSubnetGroupDescription);
            this.subnetIds(model.subnetIds);
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final String getCacheSubnetGroupDescription() {
            return this.cacheSubnetGroupDescription;
        }

        @Override
        public final Builder cacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
            return this;
        }

        public final void setCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        public CreateCacheSubnetGroupRequest build() {
            return new CreateCacheSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateCacheSubnetGroupRequest> {
        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSubnetGroupDescription(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);
    }
}

