/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopySnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CopySnapshotRequest> {
    private final String sourceSnapshotName;
    private final String targetSnapshotName;
    private final String targetBucket;

    private CopySnapshotRequest(BuilderImpl builder) {
        this.sourceSnapshotName = builder.sourceSnapshotName;
        this.targetSnapshotName = builder.targetSnapshotName;
        this.targetBucket = builder.targetBucket;
    }

    public String sourceSnapshotName() {
        return this.sourceSnapshotName;
    }

    public String targetSnapshotName() {
        return this.targetSnapshotName;
    }

    public String targetBucket() {
        return this.targetBucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceSnapshotName() == null ? 0 : this.sourceSnapshotName().hashCode());
        hashCode = 31 * hashCode + (this.targetSnapshotName() == null ? 0 : this.targetSnapshotName().hashCode());
        hashCode = 31 * hashCode + (this.targetBucket() == null ? 0 : this.targetBucket().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)((Object)obj);
        if (other.sourceSnapshotName() == null ^ this.sourceSnapshotName() == null) {
            return false;
        }
        if (other.sourceSnapshotName() != null && !other.sourceSnapshotName().equals(this.sourceSnapshotName())) {
            return false;
        }
        if (other.targetSnapshotName() == null ^ this.targetSnapshotName() == null) {
            return false;
        }
        if (other.targetSnapshotName() != null && !other.targetSnapshotName().equals(this.targetSnapshotName())) {
            return false;
        }
        if (other.targetBucket() == null ^ this.targetBucket() == null) {
            return false;
        }
        return other.targetBucket() == null || other.targetBucket().equals(this.targetBucket());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceSnapshotName() != null) {
            sb.append("SourceSnapshotName: ").append(this.sourceSnapshotName()).append(",");
        }
        if (this.targetSnapshotName() != null) {
            sb.append("TargetSnapshotName: ").append(this.targetSnapshotName()).append(",");
        }
        if (this.targetBucket() != null) {
            sb.append("TargetBucket: ").append(this.targetBucket()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceSnapshotName": {
                return Optional.of(clazz.cast(this.sourceSnapshotName()));
            }
            case "TargetSnapshotName": {
                return Optional.of(clazz.cast(this.targetSnapshotName()));
            }
            case "TargetBucket": {
                return Optional.of(clazz.cast(this.targetBucket()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceSnapshotName;
        private String targetSnapshotName;
        private String targetBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            this.sourceSnapshotName(model.sourceSnapshotName);
            this.targetSnapshotName(model.targetSnapshotName);
            this.targetBucket(model.targetBucket);
        }

        public final String getSourceSnapshotName() {
            return this.sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        public final String getTargetSnapshotName() {
            return this.targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        public final String getTargetBucket() {
            return this.targetBucket;
        }

        @Override
        public final Builder targetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
            return this;
        }

        public final void setTargetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
        }

        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopySnapshotRequest> {
        public Builder sourceSnapshotName(String var1);

        public Builder targetSnapshotName(String var1);

        public Builder targetBucket(String var1);
    }
}

