/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup;
import software.amazon.awssdk.services.elasticache.model.EC2SecurityGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CacheSecurityGroup
implements ToCopyableBuilder<Builder, CacheSecurityGroup> {
    private final String ownerId;
    private final String cacheSecurityGroupName;
    private final String description;
    private final List<EC2SecurityGroup> ec2SecurityGroups;

    private CacheSecurityGroup(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.cacheSecurityGroupName = builder.cacheSecurityGroupName;
        this.description = builder.description;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String cacheSecurityGroupName() {
        return this.cacheSecurityGroupName;
    }

    public String description() {
        return this.description;
    }

    public List<EC2SecurityGroup> ec2SecurityGroups() {
        return this.ec2SecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.cacheSecurityGroupName() == null ? 0 : this.cacheSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.ec2SecurityGroups() == null ? 0 : this.ec2SecurityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSecurityGroup)) {
            return false;
        }
        CacheSecurityGroup other = (CacheSecurityGroup)obj;
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.cacheSecurityGroupName() == null ^ this.cacheSecurityGroupName() == null) {
            return false;
        }
        if (other.cacheSecurityGroupName() != null && !other.cacheSecurityGroupName().equals(this.cacheSecurityGroupName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.ec2SecurityGroups() == null ^ this.ec2SecurityGroups() == null) {
            return false;
        }
        return other.ec2SecurityGroups() == null || other.ec2SecurityGroups().equals(this.ec2SecurityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.cacheSecurityGroupName() != null) {
            sb.append("CacheSecurityGroupName: ").append(this.cacheSecurityGroupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.ec2SecurityGroups() != null) {
            sb.append("EC2SecurityGroups: ").append(this.ec2SecurityGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "CacheSecurityGroupName": {
                return Optional.of(clazz.cast(this.cacheSecurityGroupName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "EC2SecurityGroups": {
                return Optional.of(clazz.cast(this.ec2SecurityGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String cacheSecurityGroupName;
        private String description;
        private List<EC2SecurityGroup> ec2SecurityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheSecurityGroup model) {
            this.ownerId(model.ownerId);
            this.cacheSecurityGroupName(model.cacheSecurityGroupName);
            this.description(model.description);
            this.ec2SecurityGroups(model.ec2SecurityGroups);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCacheSecurityGroupName() {
            return this.cacheSecurityGroupName;
        }

        @Override
        public final Builder cacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
            return this;
        }

        public final void setCacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EC2SecurityGroup.Builder> getEC2SecurityGroups() {
            return this.ec2SecurityGroups != null ? (Collection)this.ec2SecurityGroups.stream().map(EC2SecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        public final void setEC2SecurityGroups(Collection<EC2SecurityGroup.BuilderImpl> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copyFromBuilder(ec2SecurityGroups);
        }

        public CacheSecurityGroup build() {
            return new CacheSecurityGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheSecurityGroup> {
        public Builder ownerId(String var1);

        public Builder cacheSecurityGroupName(String var1);

        public Builder description(String var1);

        public Builder ec2SecurityGroups(Collection<EC2SecurityGroup> var1);

        public Builder ec2SecurityGroups(EC2SecurityGroup ... var1);
    }
}

