/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfigurationListCopier;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.SnapshotArnsListCopier;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateReplicationGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateReplicationGroupRequest> {
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String primaryClusterId;
    private final Boolean automaticFailoverEnabled;
    private final Integer numCacheClusters;
    private final List<String> preferredCacheClusterAZs;
    private final Integer numNodeGroups;
    private final Integer replicasPerNodeGroup;
    private final List<NodeGroupConfiguration> nodeGroupConfiguration;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final String cacheParameterGroupName;
    private final String cacheSubnetGroupName;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final List<Tag> tags;
    private final List<String> snapshotArns;
    private final String snapshotName;
    private final String preferredMaintenanceWindow;
    private final Integer port;
    private final String notificationTopicArn;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String authToken;

    private CreateReplicationGroupRequest(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.numCacheClusters = builder.numCacheClusters;
        this.preferredCacheClusterAZs = builder.preferredCacheClusterAZs;
        this.numNodeGroups = builder.numNodeGroups;
        this.replicasPerNodeGroup = builder.replicasPerNodeGroup;
        this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.port = builder.port;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authToken = builder.authToken;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public String primaryClusterId() {
        return this.primaryClusterId;
    }

    public Boolean automaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }

    public Integer numCacheClusters() {
        return this.numCacheClusters;
    }

    public List<String> preferredCacheClusterAZs() {
        return this.preferredCacheClusterAZs;
    }

    public Integer numNodeGroups() {
        return this.numNodeGroups;
    }

    public Integer replicasPerNodeGroup() {
        return this.replicasPerNodeGroup;
    }

    public List<NodeGroupConfiguration> nodeGroupConfiguration() {
        return this.nodeGroupConfiguration;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<String> snapshotArns() {
        return this.snapshotArns;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Integer port() {
        return this.port;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public String authToken() {
        return this.authToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.replicationGroupId() == null ? 0 : this.replicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.replicationGroupDescription() == null ? 0 : this.replicationGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.primaryClusterId() == null ? 0 : this.primaryClusterId().hashCode());
        hashCode = 31 * hashCode + (this.automaticFailoverEnabled() == null ? 0 : this.automaticFailoverEnabled().hashCode());
        hashCode = 31 * hashCode + (this.numCacheClusters() == null ? 0 : this.numCacheClusters().hashCode());
        hashCode = 31 * hashCode + (this.preferredCacheClusterAZs() == null ? 0 : this.preferredCacheClusterAZs().hashCode());
        hashCode = 31 * hashCode + (this.numNodeGroups() == null ? 0 : this.numNodeGroups().hashCode());
        hashCode = 31 * hashCode + (this.replicasPerNodeGroup() == null ? 0 : this.replicasPerNodeGroup().hashCode());
        hashCode = 31 * hashCode + (this.nodeGroupConfiguration() == null ? 0 : this.nodeGroupConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeType() == null ? 0 : this.cacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.cacheParameterGroupName() == null ? 0 : this.cacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.cacheSubnetGroupName() == null ? 0 : this.cacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.cacheSecurityGroupNames() == null ? 0 : this.cacheSecurityGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.snapshotArns() == null ? 0 : this.snapshotArns().hashCode());
        hashCode = 31 * hashCode + (this.snapshotName() == null ? 0 : this.snapshotName().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.notificationTopicArn() == null ? 0 : this.notificationTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.autoMinorVersionUpgrade() == null ? 0 : this.autoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.snapshotRetentionLimit() == null ? 0 : this.snapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.snapshotWindow() == null ? 0 : this.snapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.authToken() == null ? 0 : this.authToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationGroupRequest)) {
            return false;
        }
        CreateReplicationGroupRequest other = (CreateReplicationGroupRequest)((Object)obj);
        if (other.replicationGroupId() == null ^ this.replicationGroupId() == null) {
            return false;
        }
        if (other.replicationGroupId() != null && !other.replicationGroupId().equals(this.replicationGroupId())) {
            return false;
        }
        if (other.replicationGroupDescription() == null ^ this.replicationGroupDescription() == null) {
            return false;
        }
        if (other.replicationGroupDescription() != null && !other.replicationGroupDescription().equals(this.replicationGroupDescription())) {
            return false;
        }
        if (other.primaryClusterId() == null ^ this.primaryClusterId() == null) {
            return false;
        }
        if (other.primaryClusterId() != null && !other.primaryClusterId().equals(this.primaryClusterId())) {
            return false;
        }
        if (other.automaticFailoverEnabled() == null ^ this.automaticFailoverEnabled() == null) {
            return false;
        }
        if (other.automaticFailoverEnabled() != null && !other.automaticFailoverEnabled().equals(this.automaticFailoverEnabled())) {
            return false;
        }
        if (other.numCacheClusters() == null ^ this.numCacheClusters() == null) {
            return false;
        }
        if (other.numCacheClusters() != null && !other.numCacheClusters().equals(this.numCacheClusters())) {
            return false;
        }
        if (other.preferredCacheClusterAZs() == null ^ this.preferredCacheClusterAZs() == null) {
            return false;
        }
        if (other.preferredCacheClusterAZs() != null && !other.preferredCacheClusterAZs().equals(this.preferredCacheClusterAZs())) {
            return false;
        }
        if (other.numNodeGroups() == null ^ this.numNodeGroups() == null) {
            return false;
        }
        if (other.numNodeGroups() != null && !other.numNodeGroups().equals(this.numNodeGroups())) {
            return false;
        }
        if (other.replicasPerNodeGroup() == null ^ this.replicasPerNodeGroup() == null) {
            return false;
        }
        if (other.replicasPerNodeGroup() != null && !other.replicasPerNodeGroup().equals(this.replicasPerNodeGroup())) {
            return false;
        }
        if (other.nodeGroupConfiguration() == null ^ this.nodeGroupConfiguration() == null) {
            return false;
        }
        if (other.nodeGroupConfiguration() != null && !other.nodeGroupConfiguration().equals(this.nodeGroupConfiguration())) {
            return false;
        }
        if (other.cacheNodeType() == null ^ this.cacheNodeType() == null) {
            return false;
        }
        if (other.cacheNodeType() != null && !other.cacheNodeType().equals(this.cacheNodeType())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.cacheParameterGroupName() == null ^ this.cacheParameterGroupName() == null) {
            return false;
        }
        if (other.cacheParameterGroupName() != null && !other.cacheParameterGroupName().equals(this.cacheParameterGroupName())) {
            return false;
        }
        if (other.cacheSubnetGroupName() == null ^ this.cacheSubnetGroupName() == null) {
            return false;
        }
        if (other.cacheSubnetGroupName() != null && !other.cacheSubnetGroupName().equals(this.cacheSubnetGroupName())) {
            return false;
        }
        if (other.cacheSecurityGroupNames() == null ^ this.cacheSecurityGroupNames() == null) {
            return false;
        }
        if (other.cacheSecurityGroupNames() != null && !other.cacheSecurityGroupNames().equals(this.cacheSecurityGroupNames())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.snapshotArns() == null ^ this.snapshotArns() == null) {
            return false;
        }
        if (other.snapshotArns() != null && !other.snapshotArns().equals(this.snapshotArns())) {
            return false;
        }
        if (other.snapshotName() == null ^ this.snapshotName() == null) {
            return false;
        }
        if (other.snapshotName() != null && !other.snapshotName().equals(this.snapshotName())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.notificationTopicArn() == null ^ this.notificationTopicArn() == null) {
            return false;
        }
        if (other.notificationTopicArn() != null && !other.notificationTopicArn().equals(this.notificationTopicArn())) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() == null ^ this.autoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() != null && !other.autoMinorVersionUpgrade().equals(this.autoMinorVersionUpgrade())) {
            return false;
        }
        if (other.snapshotRetentionLimit() == null ^ this.snapshotRetentionLimit() == null) {
            return false;
        }
        if (other.snapshotRetentionLimit() != null && !other.snapshotRetentionLimit().equals(this.snapshotRetentionLimit())) {
            return false;
        }
        if (other.snapshotWindow() == null ^ this.snapshotWindow() == null) {
            return false;
        }
        if (other.snapshotWindow() != null && !other.snapshotWindow().equals(this.snapshotWindow())) {
            return false;
        }
        if (other.authToken() == null ^ this.authToken() == null) {
            return false;
        }
        return other.authToken() == null || other.authToken().equals(this.authToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.replicationGroupDescription() != null) {
            sb.append("ReplicationGroupDescription: ").append(this.replicationGroupDescription()).append(",");
        }
        if (this.primaryClusterId() != null) {
            sb.append("PrimaryClusterId: ").append(this.primaryClusterId()).append(",");
        }
        if (this.automaticFailoverEnabled() != null) {
            sb.append("AutomaticFailoverEnabled: ").append(this.automaticFailoverEnabled()).append(",");
        }
        if (this.numCacheClusters() != null) {
            sb.append("NumCacheClusters: ").append(this.numCacheClusters()).append(",");
        }
        if (this.preferredCacheClusterAZs() != null) {
            sb.append("PreferredCacheClusterAZs: ").append(this.preferredCacheClusterAZs()).append(",");
        }
        if (this.numNodeGroups() != null) {
            sb.append("NumNodeGroups: ").append(this.numNodeGroups()).append(",");
        }
        if (this.replicasPerNodeGroup() != null) {
            sb.append("ReplicasPerNodeGroup: ").append(this.replicasPerNodeGroup()).append(",");
        }
        if (this.nodeGroupConfiguration() != null) {
            sb.append("NodeGroupConfiguration: ").append(this.nodeGroupConfiguration()).append(",");
        }
        if (this.cacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.cacheNodeType()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.cacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.cacheParameterGroupName()).append(",");
        }
        if (this.cacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: ").append(this.cacheSubnetGroupName()).append(",");
        }
        if (this.cacheSecurityGroupNames() != null) {
            sb.append("CacheSecurityGroupNames: ").append(this.cacheSecurityGroupNames()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.snapshotArns() != null) {
            sb.append("SnapshotArns: ").append(this.snapshotArns()).append(",");
        }
        if (this.snapshotName() != null) {
            sb.append("SnapshotName: ").append(this.snapshotName()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.notificationTopicArn() != null) {
            sb.append("NotificationTopicArn: ").append(this.notificationTopicArn()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.snapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.snapshotRetentionLimit()).append(",");
        }
        if (this.snapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.snapshotWindow()).append(",");
        }
        if (this.authToken() != null) {
            sb.append("AuthToken: ").append(this.authToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String primaryClusterId;
        private Boolean automaticFailoverEnabled;
        private Integer numCacheClusters;
        private List<String> preferredCacheClusterAZs;
        private Integer numNodeGroups;
        private Integer replicasPerNodeGroup;
        private List<NodeGroupConfiguration> nodeGroupConfiguration;
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private String cacheParameterGroupName;
        private String cacheSubnetGroupName;
        private List<String> cacheSecurityGroupNames;
        private List<String> securityGroupIds;
        private List<Tag> tags;
        private List<String> snapshotArns;
        private String snapshotName;
        private String preferredMaintenanceWindow;
        private Integer port;
        private String notificationTopicArn;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String authToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationGroupRequest model) {
            this.setReplicationGroupId(model.replicationGroupId);
            this.setReplicationGroupDescription(model.replicationGroupDescription);
            this.setPrimaryClusterId(model.primaryClusterId);
            this.setAutomaticFailoverEnabled(model.automaticFailoverEnabled);
            this.setNumCacheClusters(model.numCacheClusters);
            this.setPreferredCacheClusterAZs(model.preferredCacheClusterAZs);
            this.setNumNodeGroups(model.numNodeGroups);
            this.setReplicasPerNodeGroup(model.replicasPerNodeGroup);
            this.setNodeGroupConfiguration(model.nodeGroupConfiguration);
            this.setCacheNodeType(model.cacheNodeType);
            this.setEngine(model.engine);
            this.setEngineVersion(model.engineVersion);
            this.setCacheParameterGroupName(model.cacheParameterGroupName);
            this.setCacheSubnetGroupName(model.cacheSubnetGroupName);
            this.setCacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.setSecurityGroupIds(model.securityGroupIds);
            this.setTags(model.tags);
            this.setSnapshotArns(model.snapshotArns);
            this.setSnapshotName(model.snapshotName);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setPort(model.port);
            this.setNotificationTopicArn(model.notificationTopicArn);
            this.setAutoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.setSnapshotRetentionLimit(model.snapshotRetentionLimit);
            this.setSnapshotWindow(model.snapshotWindow);
            this.setAuthToken(model.authToken);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return this.automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        public final Integer getNumCacheClusters() {
            return this.numCacheClusters;
        }

        @Override
        public final Builder numCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
            return this;
        }

        public final void setNumCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
        }

        public final Collection<String> getPreferredCacheClusterAZs() {
            return this.preferredCacheClusterAZs;
        }

        @Override
        public final Builder preferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredCacheClusterAZs(String ... preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs(Arrays.asList(preferredCacheClusterAZs));
            return this;
        }

        public final void setPreferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
        }

        public final Integer getNumNodeGroups() {
            return this.numNodeGroups;
        }

        @Override
        public final Builder numNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        public final void setNumNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
        }

        public final Integer getReplicasPerNodeGroup() {
            return this.replicasPerNodeGroup;
        }

        @Override
        public final Builder replicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
            return this;
        }

        public final void setReplicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
        }

        public final Collection<NodeGroupConfiguration> getNodeGroupConfiguration() {
            return this.nodeGroupConfiguration;
        }

        @Override
        public final Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copy(nodeGroupConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(NodeGroupConfiguration ... nodeGroupConfiguration) {
            this.nodeGroupConfiguration(Arrays.asList(nodeGroupConfiguration));
            return this;
        }

        public final void setNodeGroupConfiguration(Collection<NodeGroupConfiguration> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copy(nodeGroupConfiguration);
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public final Collection<String> getSnapshotArns() {
            return this.snapshotArns;
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String ... snapshotArns) {
            this.snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public CreateReplicationGroupRequest build() {
            return new CreateReplicationGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateReplicationGroupRequest> {
        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder primaryClusterId(String var1);

        public Builder automaticFailoverEnabled(Boolean var1);

        public Builder numCacheClusters(Integer var1);

        public Builder preferredCacheClusterAZs(Collection<String> var1);

        public Builder preferredCacheClusterAZs(String ... var1);

        public Builder numNodeGroups(Integer var1);

        public Builder replicasPerNodeGroup(Integer var1);

        public Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> var1);

        public Builder nodeGroupConfiguration(NodeGroupConfiguration ... var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder snapshotArns(Collection<String> var1);

        public Builder snapshotArns(String ... var1);

        public Builder snapshotName(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder port(Integer var1);

        public Builder notificationTopicArn(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder authToken(String var1);
    }
}

