/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.TestFailoverRequest;
import software.amazon.awssdk.util.StringUtils;

public class TestFailoverRequestMarshaller
implements Marshaller<Request<TestFailoverRequest>, TestFailoverRequest> {
    public Request<TestFailoverRequest> marshall(TestFailoverRequest testFailoverRequest) {
        if (testFailoverRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testFailoverRequest, "ElastiCacheClient");
        request.addParameter("Action", "TestFailover");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (testFailoverRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)testFailoverRequest.replicationGroupId()));
        }
        if (testFailoverRequest.nodeGroupId() != null) {
            request.addParameter("NodeGroupId", StringUtils.fromString((String)testFailoverRequest.nodeGroupId()));
        }
        return request;
    }
}

