/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest;
import software.amazon.awssdk.util.StringUtils;

public class RebootCacheClusterRequestMarshaller
implements Marshaller<Request<RebootCacheClusterRequest>, RebootCacheClusterRequest> {
    public Request<RebootCacheClusterRequest> marshall(RebootCacheClusterRequest rebootCacheClusterRequest) {
        List<String> cacheNodeIdsToRebootList;
        if (rebootCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rebootCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "RebootCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebootCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)rebootCacheClusterRequest.cacheClusterId()));
        }
        if ((cacheNodeIdsToRebootList = rebootCacheClusterRequest.cacheNodeIdsToReboot()) != null) {
            if (!cacheNodeIdsToRebootList.isEmpty()) {
                int cacheNodeIdsToRebootListIndex = 1;
                for (String cacheNodeIdsToRebootListValue : cacheNodeIdsToRebootList) {
                    if (cacheNodeIdsToRebootListValue != null) {
                        request.addParameter("CacheNodeIdsToReboot.CacheNodeId." + cacheNodeIdsToRebootListIndex, StringUtils.fromString((String)cacheNodeIdsToRebootListValue));
                    }
                    ++cacheNodeIdsToRebootListIndex;
                }
            } else {
                request.addParameter("CacheNodeIdsToReboot", "");
            }
        }
        return request;
    }
}

