/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateCacheParameterGroupRequestMarshaller
implements Marshaller<Request<CreateCacheParameterGroupRequest>, CreateCacheParameterGroupRequest> {
    public Request<CreateCacheParameterGroupRequest> marshall(CreateCacheParameterGroupRequest createCacheParameterGroupRequest) {
        if (createCacheParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCacheParameterGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateCacheParameterGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCacheParameterGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)createCacheParameterGroupRequest.cacheParameterGroupName()));
        }
        if (createCacheParameterGroupRequest.cacheParameterGroupFamily() != null) {
            request.addParameter("CacheParameterGroupFamily", StringUtils.fromString((String)createCacheParameterGroupRequest.cacheParameterGroupFamily()));
        }
        if (createCacheParameterGroupRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createCacheParameterGroupRequest.description()));
        }
        return request;
    }
}

