/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import software.amazon.awssdk.services.elasticache.model.AvailabilityZone;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subnet
implements ToCopyableBuilder<Builder, Subnet> {
    private final String subnetIdentifier;
    private final AvailabilityZone subnetAvailabilityZone;

    private Subnet(BuilderImpl builder) {
        this.subnetIdentifier = builder.subnetIdentifier;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
    }

    public String subnetIdentifier() {
        return this.subnetIdentifier;
    }

    public AvailabilityZone subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subnetIdentifier() == null ? 0 : this.subnetIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.subnetAvailabilityZone() == null ? 0 : this.subnetAvailabilityZone().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        if (other.subnetIdentifier() == null ^ this.subnetIdentifier() == null) {
            return false;
        }
        if (other.subnetIdentifier() != null && !other.subnetIdentifier().equals(this.subnetIdentifier())) {
            return false;
        }
        if (other.subnetAvailabilityZone() == null ^ this.subnetAvailabilityZone() == null) {
            return false;
        }
        return other.subnetAvailabilityZone() == null || other.subnetAvailabilityZone().equals(this.subnetAvailabilityZone());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnetIdentifier() != null) {
            sb.append("SubnetIdentifier: ").append(this.subnetIdentifier()).append(",");
        }
        if (this.subnetAvailabilityZone() != null) {
            sb.append("SubnetAvailabilityZone: ").append(this.subnetAvailabilityZone()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String subnetIdentifier;
        private AvailabilityZone subnetAvailabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.setSubnetIdentifier(model.subnetIdentifier);
            this.setSubnetAvailabilityZone(model.subnetAvailabilityZone);
        }

        public final String getSubnetIdentifier() {
            return this.subnetIdentifier;
        }

        @Override
        public final Builder subnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
            return this;
        }

        public final void setSubnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
        }

        public final AvailabilityZone getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone;
        }

        @Override
        public final Builder subnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final void setSubnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
        }

        public Subnet build() {
            return new Subnet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subnet> {
        public Builder subnetIdentifier(String var1);

        public Builder subnetAvailabilityZone(AvailabilityZone var1);
    }
}

