/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticache.model.RecurringCharge;
import software.amazon.awssdk.services.elasticache.model.RecurringChargeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedCacheNode
implements ToCopyableBuilder<Builder, ReservedCacheNode> {
    private final String reservedCacheNodeId;
    private final String reservedCacheNodesOfferingId;
    private final String cacheNodeType;
    private final Instant startTime;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final Integer cacheNodeCount;
    private final String productDescription;
    private final String offeringType;
    private final String state;
    private final List<RecurringCharge> recurringCharges;

    private ReservedCacheNode(BuilderImpl builder) {
        this.reservedCacheNodeId = builder.reservedCacheNodeId;
        this.reservedCacheNodesOfferingId = builder.reservedCacheNodesOfferingId;
        this.cacheNodeType = builder.cacheNodeType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.cacheNodeCount = builder.cacheNodeCount;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.state = builder.state;
        this.recurringCharges = builder.recurringCharges;
    }

    public String reservedCacheNodeId() {
        return this.reservedCacheNodeId;
    }

    public String reservedCacheNodesOfferingId() {
        return this.reservedCacheNodesOfferingId;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Integer duration() {
        return this.duration;
    }

    public Double fixedPrice() {
        return this.fixedPrice;
    }

    public Double usagePrice() {
        return this.usagePrice;
    }

    public Integer cacheNodeCount() {
        return this.cacheNodeCount;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public String state() {
        return this.state;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservedCacheNodeId() == null ? 0 : this.reservedCacheNodeId().hashCode());
        hashCode = 31 * hashCode + (this.reservedCacheNodesOfferingId() == null ? 0 : this.reservedCacheNodesOfferingId().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeType() == null ? 0 : this.cacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.fixedPrice() == null ? 0 : this.fixedPrice().hashCode());
        hashCode = 31 * hashCode + (this.usagePrice() == null ? 0 : this.usagePrice().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeCount() == null ? 0 : this.cacheNodeCount().hashCode());
        hashCode = 31 * hashCode + (this.productDescription() == null ? 0 : this.productDescription().hashCode());
        hashCode = 31 * hashCode + (this.offeringType() == null ? 0 : this.offeringType().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.recurringCharges() == null ? 0 : this.recurringCharges().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedCacheNode)) {
            return false;
        }
        ReservedCacheNode other = (ReservedCacheNode)obj;
        if (other.reservedCacheNodeId() == null ^ this.reservedCacheNodeId() == null) {
            return false;
        }
        if (other.reservedCacheNodeId() != null && !other.reservedCacheNodeId().equals(this.reservedCacheNodeId())) {
            return false;
        }
        if (other.reservedCacheNodesOfferingId() == null ^ this.reservedCacheNodesOfferingId() == null) {
            return false;
        }
        if (other.reservedCacheNodesOfferingId() != null && !other.reservedCacheNodesOfferingId().equals(this.reservedCacheNodesOfferingId())) {
            return false;
        }
        if (other.cacheNodeType() == null ^ this.cacheNodeType() == null) {
            return false;
        }
        if (other.cacheNodeType() != null && !other.cacheNodeType().equals(this.cacheNodeType())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.fixedPrice() == null ^ this.fixedPrice() == null) {
            return false;
        }
        if (other.fixedPrice() != null && !other.fixedPrice().equals(this.fixedPrice())) {
            return false;
        }
        if (other.usagePrice() == null ^ this.usagePrice() == null) {
            return false;
        }
        if (other.usagePrice() != null && !other.usagePrice().equals(this.usagePrice())) {
            return false;
        }
        if (other.cacheNodeCount() == null ^ this.cacheNodeCount() == null) {
            return false;
        }
        if (other.cacheNodeCount() != null && !other.cacheNodeCount().equals(this.cacheNodeCount())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        if (other.offeringType() != null && !other.offeringType().equals(this.offeringType())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        return other.recurringCharges() == null || other.recurringCharges().equals(this.recurringCharges());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reservedCacheNodeId() != null) {
            sb.append("ReservedCacheNodeId: ").append(this.reservedCacheNodeId()).append(",");
        }
        if (this.reservedCacheNodesOfferingId() != null) {
            sb.append("ReservedCacheNodesOfferingId: ").append(this.reservedCacheNodesOfferingId()).append(",");
        }
        if (this.cacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.cacheNodeType()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.fixedPrice() != null) {
            sb.append("FixedPrice: ").append(this.fixedPrice()).append(",");
        }
        if (this.usagePrice() != null) {
            sb.append("UsagePrice: ").append(this.usagePrice()).append(",");
        }
        if (this.cacheNodeCount() != null) {
            sb.append("CacheNodeCount: ").append(this.cacheNodeCount()).append(",");
        }
        if (this.productDescription() != null) {
            sb.append("ProductDescription: ").append(this.productDescription()).append(",");
        }
        if (this.offeringType() != null) {
            sb.append("OfferingType: ").append(this.offeringType()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(this.recurringCharges()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String reservedCacheNodeId;
        private String reservedCacheNodesOfferingId;
        private String cacheNodeType;
        private Instant startTime;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private Integer cacheNodeCount;
        private String productDescription;
        private String offeringType;
        private String state;
        private List<RecurringCharge> recurringCharges;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedCacheNode model) {
            this.setReservedCacheNodeId(model.reservedCacheNodeId);
            this.setReservedCacheNodesOfferingId(model.reservedCacheNodesOfferingId);
            this.setCacheNodeType(model.cacheNodeType);
            this.setStartTime(model.startTime);
            this.setDuration(model.duration);
            this.setFixedPrice(model.fixedPrice);
            this.setUsagePrice(model.usagePrice);
            this.setCacheNodeCount(model.cacheNodeCount);
            this.setProductDescription(model.productDescription);
            this.setOfferingType(model.offeringType);
            this.setState(model.state);
            this.setRecurringCharges(model.recurringCharges);
        }

        public final String getReservedCacheNodeId() {
            return this.reservedCacheNodeId;
        }

        @Override
        public final Builder reservedCacheNodeId(String reservedCacheNodeId) {
            this.reservedCacheNodeId = reservedCacheNodeId;
            return this;
        }

        public final void setReservedCacheNodeId(String reservedCacheNodeId) {
            this.reservedCacheNodeId = reservedCacheNodeId;
        }

        public final String getReservedCacheNodesOfferingId() {
            return this.reservedCacheNodesOfferingId;
        }

        @Override
        public final Builder reservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
            return this;
        }

        public final void setReservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final Integer getCacheNodeCount() {
            return this.cacheNodeCount;
        }

        @Override
        public final Builder cacheNodeCount(Integer cacheNodeCount) {
            this.cacheNodeCount = cacheNodeCount;
            return this;
        }

        public final void setCacheNodeCount(Integer cacheNodeCount) {
            this.cacheNodeCount = cacheNodeCount;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<RecurringCharge> getRecurringCharges() {
            return this.recurringCharges;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
        }

        public ReservedCacheNode build() {
            return new ReservedCacheNode(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedCacheNode> {
        public Builder reservedCacheNodeId(String var1);

        public Builder reservedCacheNodesOfferingId(String var1);

        public Builder cacheNodeType(String var1);

        public Builder startTime(Instant var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder cacheNodeCount(Integer var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder state(String var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);
    }
}

