/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyReplicationGroupRequestMarshaller
implements Marshaller<Request<ModifyReplicationGroupRequest>, ModifyReplicationGroupRequest> {
    public Request<ModifyReplicationGroupRequest> marshall(ModifyReplicationGroupRequest modifyReplicationGroupRequest) {
        List<String> securityGroupIdsList;
        List<String> cacheSecurityGroupNamesList;
        if (modifyReplicationGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyReplicationGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReplicationGroupRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)modifyReplicationGroupRequest.replicationGroupId()));
        }
        if (modifyReplicationGroupRequest.replicationGroupDescription() != null) {
            request.addParameter("ReplicationGroupDescription", StringUtils.fromString((String)modifyReplicationGroupRequest.replicationGroupDescription()));
        }
        if (modifyReplicationGroupRequest.primaryClusterId() != null) {
            request.addParameter("PrimaryClusterId", StringUtils.fromString((String)modifyReplicationGroupRequest.primaryClusterId()));
        }
        if (modifyReplicationGroupRequest.snapshottingClusterId() != null) {
            request.addParameter("SnapshottingClusterId", StringUtils.fromString((String)modifyReplicationGroupRequest.snapshottingClusterId()));
        }
        if (modifyReplicationGroupRequest.automaticFailoverEnabled() != null) {
            request.addParameter("AutomaticFailoverEnabled", StringUtils.fromBoolean((Boolean)modifyReplicationGroupRequest.automaticFailoverEnabled()));
        }
        if ((cacheSecurityGroupNamesList = modifyReplicationGroupRequest.cacheSecurityGroupNames()) != null) {
            if (!cacheSecurityGroupNamesList.isEmpty()) {
                int cacheSecurityGroupNamesListIndex = 1;
                for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                    if (cacheSecurityGroupNamesListValue != null) {
                        request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString((String)cacheSecurityGroupNamesListValue));
                    }
                    ++cacheSecurityGroupNamesListIndex;
                }
            } else {
                request.addParameter("CacheSecurityGroupNames", "");
            }
        }
        if ((securityGroupIdsList = modifyReplicationGroupRequest.securityGroupIds()) != null) {
            if (!securityGroupIdsList.isEmpty()) {
                int securityGroupIdsListIndex = 1;
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue != null) {
                        request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                    }
                    ++securityGroupIdsListIndex;
                }
            } else {
                request.addParameter("SecurityGroupIds", "");
            }
        }
        if (modifyReplicationGroupRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyReplicationGroupRequest.preferredMaintenanceWindow()));
        }
        if (modifyReplicationGroupRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)modifyReplicationGroupRequest.notificationTopicArn()));
        }
        if (modifyReplicationGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)modifyReplicationGroupRequest.cacheParameterGroupName()));
        }
        if (modifyReplicationGroupRequest.notificationTopicStatus() != null) {
            request.addParameter("NotificationTopicStatus", StringUtils.fromString((String)modifyReplicationGroupRequest.notificationTopicStatus()));
        }
        if (modifyReplicationGroupRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyReplicationGroupRequest.applyImmediately()));
        }
        if (modifyReplicationGroupRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyReplicationGroupRequest.engineVersion()));
        }
        if (modifyReplicationGroupRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyReplicationGroupRequest.autoMinorVersionUpgrade()));
        }
        if (modifyReplicationGroupRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)modifyReplicationGroupRequest.snapshotRetentionLimit()));
        }
        if (modifyReplicationGroupRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)modifyReplicationGroupRequest.snapshotWindow()));
        }
        if (modifyReplicationGroupRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)modifyReplicationGroupRequest.cacheNodeType()));
        }
        if (modifyReplicationGroupRequest.nodeGroupId() != null) {
            request.addParameter("NodeGroupId", StringUtils.fromString((String)modifyReplicationGroupRequest.nodeGroupId()));
        }
        return request;
    }
}

