/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus;
import software.amazon.awssdk.services.elasticache.model.ClusterIdListCopier;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.services.elasticache.model.NodeGroup;
import software.amazon.awssdk.services.elasticache.model.NodeGroupListCopier;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupPendingModifiedValues;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReplicationGroup
implements ToCopyableBuilder<Builder, ReplicationGroup> {
    private final String replicationGroupId;
    private final String description;
    private final String status;
    private final ReplicationGroupPendingModifiedValues pendingModifiedValues;
    private final List<String> memberClusters;
    private final List<NodeGroup> nodeGroups;
    private final String snapshottingClusterId;
    private final String automaticFailover;
    private final Endpoint configurationEndpoint;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final Boolean clusterEnabled;
    private final String cacheNodeType;

    private ReplicationGroup(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.description = builder.description;
        this.status = builder.status;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.memberClusters = builder.memberClusters;
        this.nodeGroups = builder.nodeGroups;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailover = builder.automaticFailover;
        this.configurationEndpoint = builder.configurationEndpoint;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.clusterEnabled = builder.clusterEnabled;
        this.cacheNodeType = builder.cacheNodeType;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String description() {
        return this.description;
    }

    public String status() {
        return this.status;
    }

    public ReplicationGroupPendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public List<String> memberClusters() {
        return this.memberClusters;
    }

    public List<NodeGroup> nodeGroups() {
        return this.nodeGroups;
    }

    public String snapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public String automaticFailover() {
        return this.automaticFailover;
    }

    public Endpoint configurationEndpoint() {
        return this.configurationEndpoint;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public Boolean clusterEnabled() {
        return this.clusterEnabled;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.replicationGroupId() == null ? 0 : this.replicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.pendingModifiedValues() == null ? 0 : this.pendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.memberClusters() == null ? 0 : this.memberClusters().hashCode());
        hashCode = 31 * hashCode + (this.nodeGroups() == null ? 0 : this.nodeGroups().hashCode());
        hashCode = 31 * hashCode + (this.snapshottingClusterId() == null ? 0 : this.snapshottingClusterId().hashCode());
        hashCode = 31 * hashCode + (this.automaticFailover() == null ? 0 : this.automaticFailover().hashCode());
        hashCode = 31 * hashCode + (this.configurationEndpoint() == null ? 0 : this.configurationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.snapshotRetentionLimit() == null ? 0 : this.snapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.snapshotWindow() == null ? 0 : this.snapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.clusterEnabled() == null ? 0 : this.clusterEnabled().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeType() == null ? 0 : this.cacheNodeType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroup)) {
            return false;
        }
        ReplicationGroup other = (ReplicationGroup)obj;
        if (other.replicationGroupId() == null ^ this.replicationGroupId() == null) {
            return false;
        }
        if (other.replicationGroupId() != null && !other.replicationGroupId().equals(this.replicationGroupId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.pendingModifiedValues() == null ^ this.pendingModifiedValues() == null) {
            return false;
        }
        if (other.pendingModifiedValues() != null && !other.pendingModifiedValues().equals(this.pendingModifiedValues())) {
            return false;
        }
        if (other.memberClusters() == null ^ this.memberClusters() == null) {
            return false;
        }
        if (other.memberClusters() != null && !other.memberClusters().equals(this.memberClusters())) {
            return false;
        }
        if (other.nodeGroups() == null ^ this.nodeGroups() == null) {
            return false;
        }
        if (other.nodeGroups() != null && !other.nodeGroups().equals(this.nodeGroups())) {
            return false;
        }
        if (other.snapshottingClusterId() == null ^ this.snapshottingClusterId() == null) {
            return false;
        }
        if (other.snapshottingClusterId() != null && !other.snapshottingClusterId().equals(this.snapshottingClusterId())) {
            return false;
        }
        if (other.automaticFailover() == null ^ this.automaticFailover() == null) {
            return false;
        }
        if (other.automaticFailover() != null && !other.automaticFailover().equals(this.automaticFailover())) {
            return false;
        }
        if (other.configurationEndpoint() == null ^ this.configurationEndpoint() == null) {
            return false;
        }
        if (other.configurationEndpoint() != null && !other.configurationEndpoint().equals(this.configurationEndpoint())) {
            return false;
        }
        if (other.snapshotRetentionLimit() == null ^ this.snapshotRetentionLimit() == null) {
            return false;
        }
        if (other.snapshotRetentionLimit() != null && !other.snapshotRetentionLimit().equals(this.snapshotRetentionLimit())) {
            return false;
        }
        if (other.snapshotWindow() == null ^ this.snapshotWindow() == null) {
            return false;
        }
        if (other.snapshotWindow() != null && !other.snapshotWindow().equals(this.snapshotWindow())) {
            return false;
        }
        if (other.clusterEnabled() == null ^ this.clusterEnabled() == null) {
            return false;
        }
        if (other.clusterEnabled() != null && !other.clusterEnabled().equals(this.clusterEnabled())) {
            return false;
        }
        if (other.cacheNodeType() == null ^ this.cacheNodeType() == null) {
            return false;
        }
        return other.cacheNodeType() == null || other.cacheNodeType().equals(this.cacheNodeType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.pendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.pendingModifiedValues()).append(",");
        }
        if (this.memberClusters() != null) {
            sb.append("MemberClusters: ").append(this.memberClusters()).append(",");
        }
        if (this.nodeGroups() != null) {
            sb.append("NodeGroups: ").append(this.nodeGroups()).append(",");
        }
        if (this.snapshottingClusterId() != null) {
            sb.append("SnapshottingClusterId: ").append(this.snapshottingClusterId()).append(",");
        }
        if (this.automaticFailover() != null) {
            sb.append("AutomaticFailover: ").append(this.automaticFailover()).append(",");
        }
        if (this.configurationEndpoint() != null) {
            sb.append("ConfigurationEndpoint: ").append(this.configurationEndpoint()).append(",");
        }
        if (this.snapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.snapshotRetentionLimit()).append(",");
        }
        if (this.snapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.snapshotWindow()).append(",");
        }
        if (this.clusterEnabled() != null) {
            sb.append("ClusterEnabled: ").append(this.clusterEnabled()).append(",");
        }
        if (this.cacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.cacheNodeType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String description;
        private String status;
        private ReplicationGroupPendingModifiedValues pendingModifiedValues;
        private List<String> memberClusters;
        private List<NodeGroup> nodeGroups;
        private String snapshottingClusterId;
        private String automaticFailover;
        private Endpoint configurationEndpoint;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private Boolean clusterEnabled;
        private String cacheNodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroup model) {
            this.setReplicationGroupId(model.replicationGroupId);
            this.setDescription(model.description);
            this.setStatus(model.status);
            this.setPendingModifiedValues(model.pendingModifiedValues);
            this.setMemberClusters(model.memberClusters);
            this.setNodeGroups(model.nodeGroups);
            this.setSnapshottingClusterId(model.snapshottingClusterId);
            this.setAutomaticFailover(model.automaticFailover);
            this.setConfigurationEndpoint(model.configurationEndpoint);
            this.setSnapshotRetentionLimit(model.snapshotRetentionLimit);
            this.setSnapshotWindow(model.snapshotWindow);
            this.setClusterEnabled(model.clusterEnabled);
            this.setCacheNodeType(model.cacheNodeType);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ReplicationGroupPendingModifiedValues getPendingModifiedValues() {
            return this.pendingModifiedValues;
        }

        @Override
        public final Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
        }

        public final Collection<String> getMemberClusters() {
            return this.memberClusters;
        }

        @Override
        public final Builder memberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberClusters(String ... memberClusters) {
            this.memberClusters(Arrays.asList(memberClusters));
            return this;
        }

        public final void setMemberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
        }

        @SafeVarargs
        public final void setMemberClusters(String ... memberClusters) {
            this.memberClusters(Arrays.asList(memberClusters));
        }

        public final Collection<NodeGroup> getNodeGroups() {
            return this.nodeGroups;
        }

        @Override
        public final Builder nodeGroups(Collection<NodeGroup> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copy(nodeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroups(NodeGroup ... nodeGroups) {
            this.nodeGroups(Arrays.asList(nodeGroups));
            return this;
        }

        public final void setNodeGroups(Collection<NodeGroup> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copy(nodeGroups);
        }

        @SafeVarargs
        public final void setNodeGroups(NodeGroup ... nodeGroups) {
            this.nodeGroups(Arrays.asList(nodeGroups));
        }

        public final String getSnapshottingClusterId() {
            return this.snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        public final String getAutomaticFailover() {
            return this.automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover.toString());
            return this;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        public final void setAutomaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover.toString());
        }

        public final Endpoint getConfigurationEndpoint() {
            return this.configurationEndpoint;
        }

        @Override
        public final Builder configurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
            return this;
        }

        public final void setConfigurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final Boolean getClusterEnabled() {
            return this.clusterEnabled;
        }

        @Override
        public final Builder clusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
            return this;
        }

        public final void setClusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public ReplicationGroup build() {
            return new ReplicationGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationGroup> {
        public Builder replicationGroupId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues var1);

        public Builder memberClusters(Collection<String> var1);

        public Builder memberClusters(String ... var1);

        public Builder nodeGroups(Collection<NodeGroup> var1);

        public Builder nodeGroups(NodeGroup ... var1);

        public Builder snapshottingClusterId(String var1);

        public Builder automaticFailover(String var1);

        public Builder automaticFailover(AutomaticFailoverStatus var1);

        public Builder configurationEndpoint(Endpoint var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder clusterEnabled(Boolean var1);

        public Builder cacheNodeType(String var1);
    }
}

