/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroup;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheParameterGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCacheParameterGroupsResponse> {
    private final String marker;
    private final List<CacheParameterGroup> cacheParameterGroups;

    private DescribeCacheParameterGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.cacheParameterGroups = builder.cacheParameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheParameterGroup> cacheParameterGroups() {
        return this.cacheParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.cacheParameterGroups() == null ? 0 : this.cacheParameterGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheParameterGroupsResponse)) {
            return false;
        }
        DescribeCacheParameterGroupsResponse other = (DescribeCacheParameterGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.cacheParameterGroups() == null ^ this.cacheParameterGroups() == null) {
            return false;
        }
        return other.cacheParameterGroups() == null || other.cacheParameterGroups().equals(this.cacheParameterGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.cacheParameterGroups() != null) {
            sb.append("CacheParameterGroups: ").append(this.cacheParameterGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheParameterGroup> cacheParameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheParameterGroupsResponse model) {
            this.setMarker(model.marker);
            this.setCacheParameterGroups(model.cacheParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheParameterGroup> getCacheParameterGroups() {
            return this.cacheParameterGroups;
        }

        @Override
        public final Builder cacheParameterGroups(Collection<CacheParameterGroup> cacheParameterGroups) {
            this.cacheParameterGroups = CacheParameterGroupListCopier.copy(cacheParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheParameterGroups(CacheParameterGroup ... cacheParameterGroups) {
            this.cacheParameterGroups(Arrays.asList(cacheParameterGroups));
            return this;
        }

        public final void setCacheParameterGroups(Collection<CacheParameterGroup> cacheParameterGroups) {
            this.cacheParameterGroups = CacheParameterGroupListCopier.copy(cacheParameterGroups);
        }

        @SafeVarargs
        public final void setCacheParameterGroups(CacheParameterGroup ... cacheParameterGroups) {
            this.cacheParameterGroups(Arrays.asList(cacheParameterGroups));
        }

        public DescribeCacheParameterGroupsResponse build() {
            return new DescribeCacheParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCacheParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder cacheParameterGroups(Collection<CacheParameterGroup> var1);

        public Builder cacheParameterGroups(CacheParameterGroup ... var1);
    }
}

