/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticache.model.Subnet;
import software.amazon.awssdk.services.elasticache.model.SubnetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CacheSubnetGroup
implements ToCopyableBuilder<Builder, CacheSubnetGroup> {
    private final String cacheSubnetGroupName;
    private final String cacheSubnetGroupDescription;
    private final String vpcId;
    private final List<Subnet> subnets;

    private CacheSubnetGroup(BuilderImpl builder) {
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSubnetGroupDescription = builder.cacheSubnetGroupDescription;
        this.vpcId = builder.vpcId;
        this.subnets = builder.subnets;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public String cacheSubnetGroupDescription() {
        return this.cacheSubnetGroupDescription;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheSubnetGroupName() == null ? 0 : this.cacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.cacheSubnetGroupDescription() == null ? 0 : this.cacheSubnetGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSubnetGroup)) {
            return false;
        }
        CacheSubnetGroup other = (CacheSubnetGroup)obj;
        if (other.cacheSubnetGroupName() == null ^ this.cacheSubnetGroupName() == null) {
            return false;
        }
        if (other.cacheSubnetGroupName() != null && !other.cacheSubnetGroupName().equals(this.cacheSubnetGroupName())) {
            return false;
        }
        if (other.cacheSubnetGroupDescription() == null ^ this.cacheSubnetGroupDescription() == null) {
            return false;
        }
        if (other.cacheSubnetGroupDescription() != null && !other.cacheSubnetGroupDescription().equals(this.cacheSubnetGroupDescription())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        return other.subnets() == null || other.subnets().equals(this.subnets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: ").append(this.cacheSubnetGroupName()).append(",");
        }
        if (this.cacheSubnetGroupDescription() != null) {
            sb.append("CacheSubnetGroupDescription: ").append(this.cacheSubnetGroupDescription()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String cacheSubnetGroupName;
        private String cacheSubnetGroupDescription;
        private String vpcId;
        private List<Subnet> subnets;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheSubnetGroup model) {
            this.setCacheSubnetGroupName(model.cacheSubnetGroupName);
            this.setCacheSubnetGroupDescription(model.cacheSubnetGroupDescription);
            this.setVpcId(model.vpcId);
            this.setSubnets(model.subnets);
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final String getCacheSubnetGroupDescription() {
            return this.cacheSubnetGroupDescription;
        }

        @Override
        public final Builder cacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
            return this;
        }

        public final void setCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<Subnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
        }

        @SafeVarargs
        public final void setSubnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
        }

        public CacheSubnetGroup build() {
            return new CacheSubnetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheSubnetGroup> {
        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSubnetGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);
    }
}

