/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest;

public class ModifyReplicationGroupRequestMarshaller
implements Marshaller<Request<ModifyReplicationGroupRequest>, ModifyReplicationGroupRequest> {
    public Request<ModifyReplicationGroupRequest> marshall(ModifyReplicationGroupRequest modifyReplicationGroupRequest) {
        if (modifyReplicationGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyReplicationGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReplicationGroupRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringConversion.fromString((String)modifyReplicationGroupRequest.replicationGroupId()));
        }
        if (modifyReplicationGroupRequest.replicationGroupDescription() != null) {
            request.addParameter("ReplicationGroupDescription", StringConversion.fromString((String)modifyReplicationGroupRequest.replicationGroupDescription()));
        }
        if (modifyReplicationGroupRequest.primaryClusterId() != null) {
            request.addParameter("PrimaryClusterId", StringConversion.fromString((String)modifyReplicationGroupRequest.primaryClusterId()));
        }
        if (modifyReplicationGroupRequest.snapshottingClusterId() != null) {
            request.addParameter("SnapshottingClusterId", StringConversion.fromString((String)modifyReplicationGroupRequest.snapshottingClusterId()));
        }
        if (modifyReplicationGroupRequest.automaticFailoverEnabled() != null) {
            request.addParameter("AutomaticFailoverEnabled", StringConversion.fromBoolean((Boolean)modifyReplicationGroupRequest.automaticFailoverEnabled()));
        }
        if (modifyReplicationGroupRequest.cacheSecurityGroupNames().isEmpty() && !(modifyReplicationGroupRequest.cacheSecurityGroupNames() instanceof SdkAutoConstructList)) {
            request.addParameter("CacheSecurityGroupNames", "");
        } else if (!modifyReplicationGroupRequest.cacheSecurityGroupNames().isEmpty() && !(modifyReplicationGroupRequest.cacheSecurityGroupNames() instanceof SdkAutoConstructList)) {
            List<String> cacheSecurityGroupNamesList = modifyReplicationGroupRequest.cacheSecurityGroupNames();
            int cacheSecurityGroupNamesListIndex = 1;
            for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringConversion.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (modifyReplicationGroupRequest.securityGroupIds().isEmpty() && !(modifyReplicationGroupRequest.securityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SecurityGroupIds", "");
        } else if (!modifyReplicationGroupRequest.securityGroupIds().isEmpty() && !(modifyReplicationGroupRequest.securityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> securityGroupIdsList = modifyReplicationGroupRequest.securityGroupIds();
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringConversion.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (modifyReplicationGroupRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)modifyReplicationGroupRequest.preferredMaintenanceWindow()));
        }
        if (modifyReplicationGroupRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringConversion.fromString((String)modifyReplicationGroupRequest.notificationTopicArn()));
        }
        if (modifyReplicationGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringConversion.fromString((String)modifyReplicationGroupRequest.cacheParameterGroupName()));
        }
        if (modifyReplicationGroupRequest.notificationTopicStatus() != null) {
            request.addParameter("NotificationTopicStatus", StringConversion.fromString((String)modifyReplicationGroupRequest.notificationTopicStatus()));
        }
        if (modifyReplicationGroupRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringConversion.fromBoolean((Boolean)modifyReplicationGroupRequest.applyImmediately()));
        }
        if (modifyReplicationGroupRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)modifyReplicationGroupRequest.engineVersion()));
        }
        if (modifyReplicationGroupRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)modifyReplicationGroupRequest.autoMinorVersionUpgrade()));
        }
        if (modifyReplicationGroupRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringConversion.fromInteger((Integer)modifyReplicationGroupRequest.snapshotRetentionLimit()));
        }
        if (modifyReplicationGroupRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringConversion.fromString((String)modifyReplicationGroupRequest.snapshotWindow()));
        }
        if (modifyReplicationGroupRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringConversion.fromString((String)modifyReplicationGroupRequest.cacheNodeType()));
        }
        if (modifyReplicationGroupRequest.nodeGroupId() != null) {
            request.addParameter("NodeGroupId", StringConversion.fromString((String)modifyReplicationGroupRequest.nodeGroupId()));
        }
        return request;
    }
}

