/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValue;

public class ModifyCacheParameterGroupRequestMarshaller
implements Marshaller<Request<ModifyCacheParameterGroupRequest>, ModifyCacheParameterGroupRequest> {
    public Request<ModifyCacheParameterGroupRequest> marshall(ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) {
        if (modifyCacheParameterGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyCacheParameterGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyCacheParameterGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheParameterGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringConversion.fromString((String)modifyCacheParameterGroupRequest.cacheParameterGroupName()));
        }
        if (modifyCacheParameterGroupRequest.parameterNameValues().isEmpty() && !(modifyCacheParameterGroupRequest.parameterNameValues() instanceof SdkAutoConstructList)) {
            request.addParameter("ParameterNameValues", "");
        } else if (!modifyCacheParameterGroupRequest.parameterNameValues().isEmpty() && !(modifyCacheParameterGroupRequest.parameterNameValues() instanceof SdkAutoConstructList)) {
            List<ParameterNameValue> parameterNameValuesList = modifyCacheParameterGroupRequest.parameterNameValues();
            int parameterNameValuesListIndex = 1;
            for (ParameterNameValue parameterNameValuesListValue : parameterNameValuesList) {
                if (parameterNameValuesListValue.parameterName() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterName", StringConversion.fromString((String)parameterNameValuesListValue.parameterName()));
                }
                if (parameterNameValuesListValue.parameterValue() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterValue", StringConversion.fromString((String)parameterNameValuesListValue.parameterValue()));
                }
                ++parameterNameValuesListIndex;
            }
        }
        return request;
    }
}

