/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest;

public class ModifyCacheClusterRequestMarshaller
implements Marshaller<Request<ModifyCacheClusterRequest>, ModifyCacheClusterRequest> {
    public Request<ModifyCacheClusterRequest> marshall(ModifyCacheClusterRequest modifyCacheClusterRequest) {
        if (modifyCacheClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringConversion.fromString((String)modifyCacheClusterRequest.cacheClusterId()));
        }
        if (modifyCacheClusterRequest.numCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringConversion.fromInteger((Integer)modifyCacheClusterRequest.numCacheNodes()));
        }
        if (modifyCacheClusterRequest.cacheNodeIdsToRemove().isEmpty() && !(modifyCacheClusterRequest.cacheNodeIdsToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("CacheNodeIdsToRemove", "");
        } else if (!modifyCacheClusterRequest.cacheNodeIdsToRemove().isEmpty() && !(modifyCacheClusterRequest.cacheNodeIdsToRemove() instanceof SdkAutoConstructList)) {
            List<String> cacheNodeIdsToRemoveList = modifyCacheClusterRequest.cacheNodeIdsToRemove();
            int cacheNodeIdsToRemoveListIndex = 1;
            for (String cacheNodeIdsToRemoveListValue : cacheNodeIdsToRemoveList) {
                if (cacheNodeIdsToRemoveListValue != null) {
                    request.addParameter("CacheNodeIdsToRemove.CacheNodeId." + cacheNodeIdsToRemoveListIndex, StringConversion.fromString((String)cacheNodeIdsToRemoveListValue));
                }
                ++cacheNodeIdsToRemoveListIndex;
            }
        }
        if (modifyCacheClusterRequest.azModeAsString() != null) {
            request.addParameter("AZMode", StringConversion.fromString((String)modifyCacheClusterRequest.azModeAsString()));
        }
        if (modifyCacheClusterRequest.newAvailabilityZones().isEmpty() && !(modifyCacheClusterRequest.newAvailabilityZones() instanceof SdkAutoConstructList)) {
            request.addParameter("NewAvailabilityZones", "");
        } else if (!modifyCacheClusterRequest.newAvailabilityZones().isEmpty() && !(modifyCacheClusterRequest.newAvailabilityZones() instanceof SdkAutoConstructList)) {
            List<String> newAvailabilityZonesList = modifyCacheClusterRequest.newAvailabilityZones();
            int newAvailabilityZonesListIndex = 1;
            for (String newAvailabilityZonesListValue : newAvailabilityZonesList) {
                if (newAvailabilityZonesListValue != null) {
                    request.addParameter("NewAvailabilityZones.PreferredAvailabilityZone." + newAvailabilityZonesListIndex, StringConversion.fromString((String)newAvailabilityZonesListValue));
                }
                ++newAvailabilityZonesListIndex;
            }
        }
        if (modifyCacheClusterRequest.cacheSecurityGroupNames().isEmpty() && !(modifyCacheClusterRequest.cacheSecurityGroupNames() instanceof SdkAutoConstructList)) {
            request.addParameter("CacheSecurityGroupNames", "");
        } else if (!modifyCacheClusterRequest.cacheSecurityGroupNames().isEmpty() && !(modifyCacheClusterRequest.cacheSecurityGroupNames() instanceof SdkAutoConstructList)) {
            List<String> cacheSecurityGroupNamesList = modifyCacheClusterRequest.cacheSecurityGroupNames();
            int cacheSecurityGroupNamesListIndex = 1;
            for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringConversion.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (modifyCacheClusterRequest.securityGroupIds().isEmpty() && !(modifyCacheClusterRequest.securityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SecurityGroupIds", "");
        } else if (!modifyCacheClusterRequest.securityGroupIds().isEmpty() && !(modifyCacheClusterRequest.securityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> securityGroupIdsList = modifyCacheClusterRequest.securityGroupIds();
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringConversion.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (modifyCacheClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)modifyCacheClusterRequest.preferredMaintenanceWindow()));
        }
        if (modifyCacheClusterRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringConversion.fromString((String)modifyCacheClusterRequest.notificationTopicArn()));
        }
        if (modifyCacheClusterRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringConversion.fromString((String)modifyCacheClusterRequest.cacheParameterGroupName()));
        }
        if (modifyCacheClusterRequest.notificationTopicStatus() != null) {
            request.addParameter("NotificationTopicStatus", StringConversion.fromString((String)modifyCacheClusterRequest.notificationTopicStatus()));
        }
        if (modifyCacheClusterRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringConversion.fromBoolean((Boolean)modifyCacheClusterRequest.applyImmediately()));
        }
        if (modifyCacheClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)modifyCacheClusterRequest.engineVersion()));
        }
        if (modifyCacheClusterRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)modifyCacheClusterRequest.autoMinorVersionUpgrade()));
        }
        if (modifyCacheClusterRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringConversion.fromInteger((Integer)modifyCacheClusterRequest.snapshotRetentionLimit()));
        }
        if (modifyCacheClusterRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringConversion.fromString((String)modifyCacheClusterRequest.snapshotWindow()));
        }
        if (modifyCacheClusterRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringConversion.fromString((String)modifyCacheClusterRequest.cacheNodeType()));
        }
        return request;
    }
}

