/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.ConfigureShard;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest;

public class IncreaseReplicaCountRequestMarshaller
implements Marshaller<Request<IncreaseReplicaCountRequest>, IncreaseReplicaCountRequest> {
    public Request<IncreaseReplicaCountRequest> marshall(IncreaseReplicaCountRequest increaseReplicaCountRequest) {
        if (increaseReplicaCountRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)increaseReplicaCountRequest, "ElastiCacheClient");
        request.addParameter("Action", "IncreaseReplicaCount");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (increaseReplicaCountRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringConversion.fromString((String)increaseReplicaCountRequest.replicationGroupId()));
        }
        if (increaseReplicaCountRequest.newReplicaCount() != null) {
            request.addParameter("NewReplicaCount", StringConversion.fromInteger((Integer)increaseReplicaCountRequest.newReplicaCount()));
        }
        if (increaseReplicaCountRequest.replicaConfiguration().isEmpty() && !(increaseReplicaCountRequest.replicaConfiguration() instanceof SdkAutoConstructList)) {
            request.addParameter("ReplicaConfiguration", "");
        } else if (!increaseReplicaCountRequest.replicaConfiguration().isEmpty() && !(increaseReplicaCountRequest.replicaConfiguration() instanceof SdkAutoConstructList)) {
            List<ConfigureShard> replicaConfigurationList = increaseReplicaCountRequest.replicaConfiguration();
            int replicaConfigurationListIndex = 1;
            for (ConfigureShard replicaConfigurationListValue : replicaConfigurationList) {
                if (replicaConfigurationListValue.nodeGroupId() != null) {
                    request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".NodeGroupId", StringConversion.fromString((String)replicaConfigurationListValue.nodeGroupId()));
                }
                if (replicaConfigurationListValue.newReplicaCount() != null) {
                    request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".NewReplicaCount", StringConversion.fromInteger((Integer)replicaConfigurationListValue.newReplicaCount()));
                }
                if (replicaConfigurationListValue.preferredAvailabilityZones().isEmpty() && !(replicaConfigurationListValue.preferredAvailabilityZones() instanceof SdkAutoConstructList)) {
                    request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".PreferredAvailabilityZones", "");
                } else if (!replicaConfigurationListValue.preferredAvailabilityZones().isEmpty() && !(replicaConfigurationListValue.preferredAvailabilityZones() instanceof SdkAutoConstructList)) {
                    List<String> preferredAvailabilityZonesList = replicaConfigurationListValue.preferredAvailabilityZones();
                    int preferredAvailabilityZonesListIndex = 1;
                    for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                        if (preferredAvailabilityZonesListValue != null) {
                            request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".PreferredAvailabilityZones.PreferredAvailabilityZone." + preferredAvailabilityZonesListIndex, StringConversion.fromString((String)preferredAvailabilityZonesListValue));
                        }
                        ++preferredAvailabilityZonesListIndex;
                    }
                }
                ++replicaConfigurationListIndex;
            }
        }
        if (increaseReplicaCountRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringConversion.fromBoolean((Boolean)increaseReplicaCountRequest.applyImmediately()));
        }
        return request;
    }
}

