/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;

public class DescribeCacheSubnetGroupsRequestMarshaller
implements Marshaller<Request<DescribeCacheSubnetGroupsRequest>, DescribeCacheSubnetGroupsRequest> {
    public Request<DescribeCacheSubnetGroupsRequest> marshall(DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) {
        if (describeCacheSubnetGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeCacheSubnetGroupsRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeCacheSubnetGroups");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheSubnetGroupsRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringConversion.fromString((String)describeCacheSubnetGroupsRequest.cacheSubnetGroupName()));
        }
        if (describeCacheSubnetGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeCacheSubnetGroupsRequest.maxRecords()));
        }
        if (describeCacheSubnetGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeCacheSubnetGroupsRequest.marker()));
        }
        return request;
    }
}

