/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;

public class DescribeCacheParametersRequestMarshaller
implements Marshaller<Request<DescribeCacheParametersRequest>, DescribeCacheParametersRequest> {
    public Request<DescribeCacheParametersRequest> marshall(DescribeCacheParametersRequest describeCacheParametersRequest) {
        if (describeCacheParametersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeCacheParametersRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeCacheParameters");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheParametersRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringConversion.fromString((String)describeCacheParametersRequest.cacheParameterGroupName()));
        }
        if (describeCacheParametersRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString((String)describeCacheParametersRequest.source()));
        }
        if (describeCacheParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeCacheParametersRequest.maxRecords()));
        }
        if (describeCacheParametersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeCacheParametersRequest.marker()));
        }
        return request;
    }
}

